// Imports
import $ from 'jquery';

class Wysiwyg {

    /**
     * @param element
     */
    constructor(element) {
        this.table = element;
        this.wysiwyg = {};
        this.createNewInstance(element);

        return this;
    }

    /**
     * Create a new wysiwyg instance
     */
    createNewInstance(element) {
        this.wysiwyg = $(element).redactor({
            plugins: ['advanced', 'table', 'fontcolor', 'alignment', 'source'],
            focus: false,
            minHeight: $(element).data("height") || 350,
            maxHeight: $(element).data("height") || 350,
            replaceDivs: false,
            removeEmptyTags: false,
            toolbarFixed: false,
            buttons: [
                'source', 'format', 'bold', 'italic', 'deleted',
                'lists',
                'link', 'alignment', 'horizontalrule',
            ],
        });
    }
}

export default Wysiwyg;
