import $ from 'jquery';
import Wysiwyg from './Wysiwyg';
import WysiwygAdvanced from './WysiwygAdvanced';

/**
 * Document ready function
 */
$(document).ready(function () {

    let wysiwyg = $('.is-wysiwyg');
    let wysiwygs = [];

    if (wysiwyg.length > 0) {
        $.each(wysiwyg, function (index, element) {
            if (! $(element).hasClass('instantiated-wysiwyg')) {

                if ($(element).hasClass('advanced')) {
                    wysiwygs[index] = new WysiwygAdvanced($(element));
                } else {
                    wysiwygs[index] = new Wysiwyg($(element));
                }

                $(element).addClass('instantiated-wysiwyg');
            }
        });
    }

});
