# Changelog

All notable changes to `bongo/asset` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.16] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` - Cursor IDE guidance with project structure, patterns, and conventions
  - `CLAUDE.md` - Claude Code quick reference with commands, architecture summary, and key files (expanded from basic to comprehensive)
  - `ARCHITECTURE.md` - Detailed architecture with directory structure, class diagrams, data flows, and extension points
  - `.github/copilot-instructions.md` - GitHub Copilot code templates and patterns
  - Enhanced `README.md` with comprehensive user-facing documentation
- **MenuBuilder Multi-Level Dropdown**: Complete hierarchical menu editing system (DT-551)
  - Multi-level nested child item support (unlimited depth)
  - Recursive menu structure with parent/child relationships
  - JSON:API standard compliance for all menu operations
  - Real-time create, update, and delete operations
  - Fixed sort order functionality for nested items
  - Enhanced visual styling to match show screen
  - Removed `MenuBuilderChildItem.vue` component (consolidated into `MenuBuilderItem.vue`)
- **SchemaEditor Components**: JSON Schema editing functionality (DT-518)
  - `SchemaEditor.vue` - Main schema editor component
  - `SchemaEditorButton.vue` - Schema editor trigger button
  - `CustomSchemaEditor.vue` - Custom schema editing interface
  - Individual page schema support
- **EstimatePlanBuilder Components**: Plan item management system (DT-470)
  - `EstimatePlanBuilder.vue` - Main plan builder container
  - `EstimatePlanForm.vue` - Plan item form
  - `EstimatePlanItem.vue` - Plan item display
  - Drag-and-drop reordering
  - Full CRUD operations
- **Documentation**: Added `.gitignore` entries for system files

### Changed
- **MenuBuilder Refactoring**: Complete rewrite to JSON:API standard
  - Updated `MenuBuilder.vue` to use JSON:API data format
  - Updated `MenuBuilderForm.vue` with new field structure
  - Updated `MenuBuilderItem.vue` for recursive rendering
  - Simplified component state management
  - Improved error handling and validation
  - Better loading states and user feedback
  - Added missing default fields (sort_id, parent_id, level, etc.)
- **EstimatePlanBuilder Improvements**: Enhanced plan builder functionality (DT-470)
  - Improved form layout and field organization
  - Better item display with more details
  - Enhanced validation and error handling
- **FormBuilder HTML Section**: Added HTML section support (DT-435)
  - New "html" item type for custom HTML content
  - Fixed save rules validation for HTML sections
  - Enhanced `FormBuilderForm.vue` with HTML editor
  - Updated `FormBuilderItem.vue` to display HTML preview
- **DocumentManager Enhancements**: View/download document links (DT-458)
  - Added view link functionality
  - Added download link functionality
  - Updated `DocumentManager.vue` with link generation
  - Enhanced `DocumentManagerItem.vue` with link display buttons
- **MenuBuilder Document Links**: Document linking in menu items (DT-458)
  - Added document_id field to menu form
  - Document selection in `MenuBuilderForm.vue`
- **ColorPicker**: Minor visual improvements
- **Compiled Assets**: Regenerated backend.css and backend.js with all new components

### Fixed
- **MenuBuilder Sort Order**: Fixed broken sort order functionality for nested child items
  - Properly updates sort_id on drag-and-drop
  - Maintains correct ordering across all nesting levels
- **MenuBuilder Deep Nesting**: Fixed issue where level 3+ items wouldn't save or display
  - Recursive component rendering now works at any depth
  - Parent/child relationships properly maintained
- **FormBuilder HTML Validation**: Fixed save rules when item type is "html"
  - HTML sections no longer require validation rules
  - Proper field validation for different item types

### Security
- Updated npm dependencies to address vulnerabilities
- Updated `package-lock.json` with secure dependency versions

## [2.0.34] - 2024-10-07

### Changed
- **Laravel 10 Upgrade**: Updated for Laravel 10.x compatibility
  - Updated AssetServiceProvider to Laravel 10 syntax
  - Updated `.editorconfig` and `.styleci.yml` configurations
  - Updated composer.json dependencies
  - Updated README documentation
  - Updated npm dependencies in package.json
  - Updated Babel configuration
- **Authentication**: Updated `auth.json` credentials
- **Removed Favicons**: Deleted favicon assets (moved to theme package)
  - Removed all android-icon-*.png files
  - Removed all apple-icon-*.png files
  - Removed all ms-icon-*.png files
  - Removed favicon.ico, browserconfig.xml, manifest.json
  - Removed icon-128x128.png through icon-512x512.png
- **Asset Cleanup**: Removed unused compiled JavaScript chunks

### Fixed
- Updated package-lock.json to resolve dependency conflicts

---

**Package**: `bongo/asset`
**Description**: Provides the styles and javascript for the admin section
**Repository**: https://bitbucket.org/designtec/asset
