$(document).ready(function () {

    // minimum 8 characters
    let bad = /(?=.{8,}).*/;

    // Alpha Numeric plus minimum 8
    let good = /^(?=\S*?[a-z])(?=\S*?[0-9])\S{8,}$/;

    // Must contain at least one upper case letter, one lower case letter and (one number OR one special char).
    let better = /^(?=\S*?[A-Z])(?=\S*?[a-z])((?=\S*?[0-9])|(?=\S*?[^\w\*]))\S{8,}$/;

    // Must contain at least one upper case letter, one lower case letter and (one number AND one special char).
    let best = /^(?=\S*?[A-Z])(?=\S*?[a-z])(?=\S*?[0-9])(?=\S*?[^\w\*])\S{8,}$/;


    $("[type=password]")
        .on('keyup', function () {

            let password = $(this).val();
            let strength = 'Weak';
            let pclass = 'danger';

            // Test the different strengths
            if (best.test(password) === true) {
                strength = 'Very Strong';
                pclass = 'success';

            } else if (better.test(password) === true) {
                strength = 'Strong';
                pclass = 'warning';

            } else if (good.test(password) === true) {
                strength = 'Almost Strong';
                pclass = 'warning';

            } else if (bad.test(password) === true) {
                strength = 'Weak';

            } else {
                strength = 'Very Weak';
            }

            // Remove the old popover
            $(this).popover('dispose');

            // Update the template and show the popover
            $(this).popover({
                content: strength,
                template: `<div class="popover ${pclass}" role="tooltip"><div class="arrow"></div><div class="popover-body"></div></div>`
            });

            // Show the new popover
            $(this).popover('show');

        }).on('blur', function () {
        $(this).popover('dispose');
    });
});
