/**
 * Bind the confirmation alert
 */
function bindConfirmDeleteAlert() {

    // If there is no elements then bail
    if (! $('.confirm-delete').length) {
        return;
    }

    // Loop through all the delete forms and attach the confirmation dialogue
    $('.confirm-delete').each(function () {
        let form = $(this);
        form.submit(function (e) {
            e.preventDefault();

            // Show the confirm dialogue
            window.swal.fire({
                title: 'Are you sure?',
                text: "Please click confirm to delete this item",
                type: 'warning',
                showCancelButton: true,
                heightAuto: false,
                confirmButtonColor: '#D9534F',
                cancelButtonColor: '#DDDDDD',
                confirmButtonText: 'Yes, delete it!'

            }).then((result) => {
                if (result.value) {
                    form.off("submit").submit();
                } else if (result.dismiss === window.swal.DismissReason.cancel) { // dismiss can be 'cancel', 'overlay', 'close', and 'timer'
                    window.swal.fire({ // Show the cancle dialogue
                        title: 'Delete Cancelled',
                        type: 'error',
                        timer: 1000,
                        heightAuto: false,
                        confirmButtonColor: '#DDDDDD',
                    });
                }
            })
        });
    });
}

/**
 * Document ready function
 */
$(document).ready(function () {
    bindConfirmDeleteAlert();
});
