// Imports
import $ from 'jquery';

class WysiwygAdvanced {

    /**
     * Constructor
     *
     * @param element
     */
    constructor(element) {
        this.table = element;
        this.wysiwyg = {};
        this.createNewInstance(element);

        return this;
    }

    /**
     * Create a new wysiwyg instance
     */
    createNewInstance(element) {
        // Get the controller URL and initialize redactor
        let url = $(element).data("url");
        let token = document.head.querySelector('meta[name="csrf-token"]');

        this.wysiwyg = $(element).redactor({
            plugins: ['advanced', 'video', 'table', 'fontcolor', 'alignment', 'source'],
            focus: false,
            minHeight: $(element).data("height") || 350,
            maxHeight: $(element).data("height") || 350,
            replaceDivs: false,
            convertVideoLinks: true,
            removeEmptyTags: false,
            toolbarFixed: false,
            imageResizable: true,
            imagePosition: true,
            buttons: [
                'source', 'format', 'bold', 'italic', 'deleted',
                'lists', 'image', 'video',
                'link', 'alignment', 'horizontalrule', // 'file',
            ],
            imageGetJson: url,
            imageUpload: url + '/store',
            clipboardUploadUrl: url + '/copy',
            imageUploadFields: {'_token': token.content}
        });
    }
}

export default WysiwygAdvanced;
