// tailwind.config.js
const defaultTheme = require('tailwindcss/defaultTheme')

module.exports = {
    purge: [
        './../../**/src/Views/**/*.blade.php',
        './resources/js/**/*.vue'
    ],
    theme: {
        extend: {
            fontFamily: {
                sans: ['Inter var', ...defaultTheme.fontFamily.sans]
            },
            colors: {
                'primary': {
                    '100': '#D4E477',
                    '200': '#CEE166',
                    '300': '#C9DD55',
                    '400': '#C3DA44',
                    '500': '#BED62F',
                    '600': '#B4CC28',
                    '700': '#A5BB25',
                    '800': '#96AA22',
                    '900': '#87991E',
                },
                'light': {
                    '100': '#F5F5F5',
                    '200': '#F2F2F2',
                    '300': '#F1F1F1',
                    '400': '#EFEFEF',
                    '500': '#EEEEEE',
                    '600': '#E5E5E5',
                    '700': '#E2E2E2',
                    '800': '#DDDDDD',
                    '900': '#D9D9D9',
                },
                'medium': {
                    '100': '#cccccc',
                    '200': '#bbbbbb',
                    '300': '#aaaaaa',
                    '400': '#999999',
                    '500': '#888888',
                    '600': '#777777',
                    '700': '#666666',
                    '800': '#555555',
                    '900': '#4B4B4B',
                },
                'dark': {
                    '100': '#444444',
                    '200': '#363636',
                    '300': '#333333',
                    '400': '#282828',
                    '500': '#222222',
                    '600': '#1f1f1f',
                    '700': '#1c1c1c',
                    '800': '#191919',
                    '900': '#161616',
                    'alpha': 'rgba(0, 0, 0, 0.8)',
                    'alpha-500': 'rgba(34, 34, 34, 0.8)',
                },
            },
            minHeight: {
                '0': '0',
                '1/4': '25%',
                '1/2': '50%',
                '3/4': '75%',
                'full': '100%',
            },
        },
        variants: {},
    },
    plugins: [
        require('@tailwindcss/ui'),
    ]
};
