// Imports
const mix = require('laravel-mix');
const tailwindcss = require('tailwindcss');

// Debugging only
// const glob = require('glob-all');
// let files = glob.sync([
//     './../../**/src/Views/**/*.blade.php',
// ]);
// console.log('here are the files');
// console.log(files);

// Override the paths
mix.setPublicPath('./public')
    .setResourceRoot('./resources');

// Copy the files to the public folder
mix.copyDirectory('./resources/images', './public/images');

// Override mix internal webpack output configuration
mix.config.webpackConfig.output = {
    chunkFilename: 'js/[name].bundle.js',
    publicPath: '/',
};

// Compile Sass Files
mix.sass('./resources/sass/backend.scss', './public/css')
    .options({
        processCssUrls: false,
        postCss: [
            tailwindcss('tailwind.config.js')
        ],
    });

// Compile Js files
mix.js('./resources/js/backend.js', './public/js');

// Autoload
mix.autoload({
    jquery: ['$', 'jQuery', 'window.jQuery']
});

// If this is local then run browser sync, valet secure does not work with this
if (! mix.inProduction()) {
    mix.sourceMaps();
    mix.webpackConfig({
        devtool: 'inline-source-map'
    });
}
