# Changelog

All notable changes to `bongo/blade` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.5] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` - Cursor IDE guidance with project structure, patterns, and conventions
  - `CLAUDE.md` - Claude Code quick reference with commands, architecture summary, and key files
  - `ARCHITECTURE.md` - Detailed architecture with directory structure, class diagrams, data flows, and extension points
  - `.github/copilot-instructions.md` - GitHub Copilot code templates and patterns
  - Enhanced `README.md` with comprehensive user-facing documentation
- **Estimate Icon**: New SVG icon for estimates functionality (DT-323)
  - Added `src/Views/icons/estimate.blade.php`
- **Layout Icon**: New SVG icon for header/footer templates (DT-305)
  - Added `src/Views/icons/layout.blade.php`

### Changed
- **Laravel 10 Upgrade**: Full framework upgrade to Laravel 10.x compatibility
  - Updated BladeServiceProvider to Laravel 10 syntax
  - Updated BladeManager for Laravel 10 Blade system
  - Updated `.editorconfig` and `.styleci.yml` configurations
  - Updated composer.json dependencies
  - Updated README documentation
- **PHP 8.2 Requirement**: Minimum PHP version now 8.2
  - Added strict types declarations
  - Updated type hints throughout codebase
- **BladeServiceProvider**: Simplified service provider
  - Removed deprecated methods
  - Cleaner boot sequence
- **BladeManager**: Refactored directive registration
  - Streamlined registration methods
  - Better organization
  - Improved performance
- **Form Components**: Enhanced input field handling (DT-305)
  - Fixed duplicate field labels/IDs
  - Improved label generation from field names
  - Better ID sanitization
  - Enhanced error state handling
- **Input Component**: Updated to prevent ID conflicts
  - Dynamic ID generation from name attribute
  - Proper array field name handling
- **Label Component**: Improved label association
  - Auto-generates labels from field names if not provided
  - Better handling of array notation in names
- **Select Component**: Enhanced dropdown functionality
  - Fixed duplicate IDs
  - Improved option rendering
- **Textarea Component**: Updated text area fields
  - Fixed duplicate IDs
  - Better multi-line handling
- **Multiselect Component**: Enhanced multi-select dropdowns
  - Better rendering
  - Improved option handling
- **Static Component**: Updated static field display
  - Better read-only field handling
- **WYSIWYG Component**: Minor improvements
  - Better editor integration
- **Button Components**: Updated button styling
  - Removed unnecessary attributes
  - Cleaner HTML output
- **Breadcrumbs Component**: Updated for Laravel 10
  - Better route handling
  - Improved styling
- **Message Component**: Enhanced flash message display
  - Better error formatting
  - Improved success/warning/info styling
- **Error Icons**: Updated SVG icons (estimate, form, gallery, image, layout, project)

### Fixed
- **Duplicate Field IDs**: Fixed issue where multiple form fields could have the same ID (DT-305)
  - Now uses name attribute to generate unique IDs
  - Properly handles array notation in field names
- **Label Association**: Labels now correctly associate with their inputs
  - Fixed for attribute matching

## [2.0.14] - 2024-10-07

### Changed
- Updated authentication credentials in `auth.json`
- Updated `.editorconfig` and `.styleci.yml` configurations
- Updated README documentation
- Added IDE configuration

### Fixed
- Minor bug fixes and improvements

---

**Package**: `bongo/blade`
**Description**: Provides custom blade directives inc input, textarea, select, checkbox and buttons for Laravel
**Repository**: https://bitbucket.org/designtec/blade
