<?php

namespace Bongo\Blade\Services;

use Illuminate\Support\Facades\Blade;

class BladeManager
{
    public function register(): void
    {
        $this->registerFormGroupDirective();
        $this->registerLabelDirective();
        $this->registerStaticDirective();

        // Form fields
        $this->registerCheckboxDirective();
        $this->registerInputDirective();
        $this->registerSelectDirective();
        $this->registerMultiSelectDirective();
        $this->registerTextareaDirective();
        $this->registerWysiwygDirective();

        // Buttons
        $this->registerCreateButtonDirective();
        $this->registerEditButtonDirective();
        $this->registerShowButtonDirective();
        $this->registerSaveButtonDirective();
        $this->registerDeleteButtonDirective();
        $this->registerBackButtonDirective();
        $this->registerLinkButtonDirective();
    }

    protected function registerFormGroupDirective(): void
    {
        Blade::directive('formgroup', function () {
            return '<div class="form-group">';
        });

        Blade::directive('endformgroup', function () {
            return '</div>';
        });
    }

    protected function registerLabelDirective(): void
    {
        Blade::include('blade::label', 'label');
    }

    protected function registerStaticDirective(): void
    {
        Blade::include('blade::static', 'static');
    }

    protected function registerCheckboxDirective(): void
    {
        Blade::include('blade::checkbox', 'checkbox');
    }

    protected function registerInputDirective(): void
    {
        Blade::include('blade::input', 'input');
    }

    protected function registerSelectDirective(): void
    {
        Blade::include('blade::select', 'select');
    }

    protected function registerMultiSelectDirective(): void
    {
        Blade::include('blade::multiselect', 'multiSelect');
    }

    protected function registerTextareaDirective(): void
    {
        Blade::include('blade::textarea', 'textarea');
    }

    protected function registerWysiwygDirective(): void
    {
        Blade::include('blade::wysiwyg', 'wysiwyg');
    }

    protected function registerCreateButtonDirective(): void
    {
        Blade::include('blade::button_create', 'createButton');
    }

    protected function registerEditButtonDirective(): void
    {
        Blade::include('blade::button_edit', 'editButton');
    }

    protected function registerShowButtonDirective(): void
    {
        Blade::include('blade::button_show', 'showButton');
    }

    protected function registerSaveButtonDirective(): void
    {
        Blade::include('blade::button_save', 'saveButton');
    }

    protected function registerDeleteButtonDirective(): void
    {
        Blade::include('blade::button_delete', 'deleteButton');
    }

    protected function registerBackButtonDirective(): void
    {
        Blade::include('blade::button_back', 'backButton');
    }

    protected function registerLinkButtonDirective(): void
    {
        Blade::include('blade::button_link', 'linkButton');
    }
}
