@if (isset($breadcrumbs) && !empty($breadcrumbs))
    <div>
        <nav class="hidden md:flex items-center text-sm leading-5 font-medium">

            @foreach ($breadcrumbs as $breadcrumb)
                @if (is_array($breadcrumb))
                    <a href="{{ $breadcrumb['url'] }}"
                       class="text-gray-500 hover:text-gray-700 transition duration-150 ease-in-out" tabindex="-1"
                    >
                        {{ $breadcrumb['label'] }}
                    </a>
                    <svg class="flex-shrink-0 mx-2 h-5 w-5 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd"
                              d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z"
                              clip-rule="evenodd"
                        />
                    </svg>
                @else
                    <span class="text-gray-500 hover:text-gray-700 transition duration-150 ease-in-out">
                        {{ $breadcrumb }}
                    </span>
                @endif
            @endforeach

        </nav>
    </div>
@endif
