@php($multiple = isset($multiple) && $multiple == true)

<div class="form-group">
    @include('blade::label')

    <div class="mt-1 relative rounded-sm shadow-sm">
        <select
            id="{{ str($id ?? $name)->slug() }}"
            name="{{ $name }}"
            class="form-input block w-full rounded-sm sm:text-sm sm:leading-5 pr-10 {{ $errors->has($name) ? 'border-red-300 text-red-900 placeholder-red-300 focus:border-red-300 focus:shadow-outline-red' : '' }}"
            {!! $attributes ?? '' !!}
            {{ isset($required) ? 'required' :  '' }}
        >

            @if (isset($placeholder))
                <option selected value="">{{ $placeholder }}</option>
            @endif

            @if (!empty($default) && is_array($default))
                <option value="{{ key($default) }}">
                    {{ reset($default) }}
                </option>
            @endif

            @if (count($options))
                @foreach($options as $key => $text)
                    <option value="{{ $key }}" {{ isset($value) && $value == $key ? 'selected' : '' }}>
                        {{ $text }}
                    </option>
                @endforeach
            @endif
        </select>

        <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-500">
            <svg class="fill-current h-4 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                <path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"/>
            </svg>
        </div>
    </div>

    @php($name = str_replace(['[', ']'], '', $name))
    @include('blade::error')
</div>
