<div class="form-group">
    @include('blade::label')

    <div class="mt-1 relative rounded-sm shadow-sm">
        <textarea
            id="{{ str($id ?? $name)->slug() }}"
            name="{{ $name }}"
            class="form-input block w-full rounded-sm sm:text-sm sm:leading-5 {{ $errors->has($name) ? 'pr-10 border-red-300 text-red-900 placeholder-red-300 focus:border-red-300 focus:shadow-outline-red' : '' }}"
            placeholder="{{ $placeholder ?? '' }}"
            rows="{{ $rows ?? 3 }}"
            style="{{ ($resizable ?? true) ? '' : 'resize: none' }}"
            maxlength="{{ $maxlength ?? null }}"
            {{ ($disabled ?? false) ? 'disabled="disabled"' :  '' }}
            {{ ($required ?? false) ? 'required="true"' :  '' }}
        >{!! old($name, $value ?? null) !!}</textarea>

        @include('blade::error_icon')
    </div>

    @include('blade::error')
</div>
