<?php

namespace Bongo\Blade;

use Bongo\Blade\Services\BladeManager;
use Bongo\Framework\Providers\AbstractServiceProvider;
use Illuminate\Contracts\Container\BindingResolutionException;

class BladeServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'blade';

    public function register(): void
    {
        parent::register();

        $this->app->bind('blade_manager', BladeManager::class);
    }

    /**
     * @throws BindingResolutionException
     */
    public function boot(): void
    {
        parent::boot();

        $this->app->make('blade_manager')->register();
    }
}
