<form id="{{ Str::random(10) }}" class="form-delete confirm-delete" method="POST" action="{{ $url }}">
    @method('delete')
    {{ csrf_field() }}

    <span class="mb-2 mr-3 md:mb-0 lg:mr-0 lg:ml-3 inline-flex rounded-sm shadow-sm {{ $class ?? '' }}">
        <button
            class="inline-flex items-center px-4 py-2 border border-transparent text-sm leading-5 font-medium rounded-sm text-white bg-red-500 hover:bg-red-600 focus:outline-none focus:shadow-outline-red focus:border-red-700 active:bg-red-700 transition duration-150 ease-in-out"
            title="{{ $name ?? 'Delete' }}"
            aria-label="{{ $name ?? 'Delete' }}"
            v-tooltip='"<b>{{ $name ?? '' }}?</b> this cannot be undone"'
        >
            <svg class="-ml-1 mr-2 h-5 w-5 text-red-300" fill="currentColor" viewBox="0 0 20 20">
                <path d="M4 3a2 2 0 100 4h12a2 2 0 100-4H4z"></path>
                <path d="M3 8h14v7a2 2 0 01-2 2H5a2 2 0 01-2-2V8zm5 3a1 1 0 011-1h2a1 1 0 110 2H9a1 1 0 01-1-1z"
                      clip-rule="evenodd" fill-rule="evenodd"
                ></path>
            </svg>
            {{ $name ?? 'Delete' }}
        </button>
    </span>
</form>

