<div class="form-group">
    @include('blade::label')

    <div class="mt-1 relative rounded-sm shadow-sm">
        <input
            id="{{ str($id ?? $name)->slug() }}"
            type="{{ $type ?? 'text' }}"
            class="form-input block w-full rounded-sm sm:text-sm sm:leading-5 {{ $class ?? '' }} {{ $errors->has($name) ? 'pr-10 border-red-300 text-red-900 placeholder-red-300 focus:border-red-300 focus:shadow-outline-red' : '' }}"
            placeholder="{{ $placeholder ?? '' }}"
            name="{{ $name }}"
            autocomplete="{{ $name }}"
            value="{{ old($name, $value ?? null) }}"
            maxlength="{{ $maxlength ?? null }}"
            {{ isset($step) ? "step=$step" : '' }}
            {{ isset($min) ? "min=$min" : '' }}
            {{ isset($required) ? 'required' :  '' }}
            {{ isset($disabled) ? 'disabled' :  '' }}
            {!! isset($custom) ? implode($custom, ' ') : '' !!}
        />

        @include('blade::error_icon')
    </div>

    @include('blade::error')
</div>
