{{-- No Javascript --}}
<noscript>
    <div class="fixed bottom-0 right-0 z-20 mr-4 md:mb-4 md:mr-10">
        <div class="flex flex-col">

            <div class="rounded-sm bg-red-100 p-4 mb-4 border border-red-400 shadow-xl">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd"
                                  d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                  clip-rule="evenodd"
                            />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm leading-5 font-medium text-red-800">
                            JavaScript Disabled:
                        </h3>
                        <div class="text-sm leading-5 text-red-700">
                            <p>
                                You must have JavaScript enabled to utilize the functionality of this website.
                            </p>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</noscript>

{{-- Internet Explorer Message --}}
<!--[if lt IE 9]>
<div class="fixed bottom-0 right-0 z-20 mr-4 md:mb-4 md:mr-10">
    <div class="flex flex-col">

        <div class="rounded-sm bg-red-100 p-4 mb-4 border border-red-400 shadow-xl">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd"
                              d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                              clip-rule="evenodd"
                        />
                    </svg>
                </div>
                <div class="ml-3">
                    <h3 class="text-sm leading-5 font-medium text-red-800">
                        Legacy Browser Detected:
                    </h3>
                    <div class="text-sm leading-5 text-red-700">
                        <p>
                            Please update to the latest version of
                            <a class="underline hover:text-red-900 hover:no-underline"
                               href="https://www.microsoft.com/en-gb/download/internet-explorer.aspx"
                               target="_blank"
                            >
                                Internet Explorer
                            </a>
                            to continue.
                        </p>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<![endif]-->

{{-- Default error --}}
@if ($errors->any())
    <div class="fixed bottom-0 right-0 z-20 mr-4 md:mb-4 md:mr-10">
        <div class="flex flex-col">

            <div class="rounded-sm bg-red-100 p-4 mb-4 border border-red-400 shadow-xl">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd"
                                  d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                  clip-rule="evenodd"
                            />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm leading-5 font-medium text-red-800">
                            There were {{ count($errors) }} errors with your submission
                        </h3>
                        <div class="text-sm leading-5 text-red-700">
                            <ul class="list-disc pl-5">
                                @foreach ($errors->all() as $error)
                                    <li class="mt-1">
                                        {{ $error }}
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endif

{{-- Controller messages --}}
@if (session()->has('message'))
    <div class="fixed bottom-0 right-0 z-20 mr-4 md:mb-4 md:mr-10">
        <div class="flex flex-col">

            @if(session()->has('message_type') && session()->get('message_type') == 'warning')
                <div class="rounded-sm bg-yellow-100 p-4 mb-4 border border-yellow-400 shadow-xl">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-yellow-400" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd"
                                      d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z"
                                      clip-rule="evenodd"
                                />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm leading-5 font-medium text-yellow-800">
                                {{ ucwords(session()->get('message_type')) }}
                            </h3>
                            <div class="text-sm leading-5 text-yellow-700">
                                <p>
                                    {{ session()->get('message') }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            @if(session()->has('message_type') && session()->get('message_type') == 'success')
                <div class="rounded-sm bg-green-100 p-4 mb-4 border border-green-400 shadow-xl">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-green-400" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd"
                                      d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                      clip-rule="evenodd"
                                />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm leading-5 font-medium text-green-800">
                                {{ ucwords(session()->get('message_type')) }}
                            </h3>
                            <div class="text-sm leading-5 text-green-700">
                                <p>
                                    {{ session()->get('message') }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            @if(session()->has('message_type') && session()->get('message_type') == 'info')
                <div class="rounded-sm bg-blue-100 p-4 mb-4 border border-blue-400 shadow-xl">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-blue-400" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd"
                                      d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z"
                                      clip-rule="evenodd"
                                />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm leading-5 font-medium text-blue-800">
                                {{ ucwords(session()->get('message_type')) }}
                            </h3>
                            <div class="text-sm leading-5 text-blue-700">
                                <p>
                                    {{ session()->get('message') }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            @if(session()->has('message_type') && session()->get('message_type') == 'danger')
                <div class="rounded-sm bg-red-100 p-4 mb-4 border border-red-400 shadow-xl">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd"
                                      d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                      clip-rule="evenodd"
                                />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm leading-5 font-medium text-red-800">
                                {{ ucwords(session()->get('message_type')) }}
                            </h3>
                            <div class="text-sm leading-5 text-red-700">
                                <p>
                                    {{ session()->get('message') }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

        </div>
    </div>
@endif

