<div class="form-group">
    @include('blade::label')

    <div class="mt-1 relative rounded-sm shadow-sm">
        <select
            id="{{ $id ?? ($name.'-field') }}"
            name="{{ $name }}"
            size="{{ $size ?? 3 }}"
            multiple
            style="resize: vertical;"
            class="form-input block w-full rounded-sm sm:text-sm sm:leading-5 {{ $errors->has($name) ? 'border-red-300 text-red-900 placeholder-red-300 focus:border-red-300 focus:shadow-outline-red' : '' }}"
            {!! $attributes ?? '' !!}
            {{ isset($required) ? 'required' :  '' }}
        >

            @if (isset($placeholder))
                <option selected value="">{{ $placeholder }}</option>
            @endif

            @if (!empty($default) && is_array($default))
                <option value="{{ key($default) }}">
                    {{ reset($default) }}
                </option>
            @endif

            @if (count($options))
                @foreach($options as $key => $text)
                    <option value="{{ $key }}" {{ in_array($key, $value) ? 'selected' : '' }}>
                        {{ $text }}
                    </option>
                @endforeach
            @endif
        </select>
    </div>

    @php($name = str_replace(['[', ']'], '', $name))
    @include('blade::error')
</div>
