# Changelog

All notable changes to `bongo/builder` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.65] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` (281 lines) - Cursor IDE guidance with project structure and patterns
  - `CLAUDE.md` (524 lines) - Claude Code quick reference with commands and architecture
  - `ARCHITECTURE.md` (1027 lines) - Detailed architecture with ASCII diagrams, data flows, and extension points
  - `.github/copilot-instructions.md` (384 lines) - GitHub Copilot code templates and patterns
- **Enhanced README.md**: Expanded with comprehensive installation, usage, and architecture sections (468 new lines)

### Changed
- **DT-557**: Updated section and component headings across all templates for improved consistency
- **DT-555**: Updated footer layouts with modern design patterns
- Merged v3.0 branch improvements into main
  - Updated HTML escaping across 200+ component Blade templates for improved XSS protection
  - Standardized Blade directive usage (changed `{!! !!}` to `{{ }}`) across achievement, basic, contact, feature, headline, help-faq, photos, pricing, process, product, profile, quote, and skill component categories
  - Minor template refinements for consistency across designs and layouts

## [3.0.0] - 2025-12-01

### Major Release - v3.0

This major version represents a complete overhaul of the builder package with significant improvements to file management, asset optimization, and modern web development practices.

### Added

#### New Components
- **DT-520**: Section Call To Action 03 - Modern CTA design
- **DT-528**: Services Component 20 - Service display template
- **DT-522**: Blurry Header with Animated Button - Interactive header component
- **DT-500**: Component services-19 - Service listing template
- **DT-420**: Photos-16 Component - Photo gallery layout
- **DT-467**: Service Box 18 - Service box component
- **DT-463**: Component services 16 & 17 - Additional service templates
- **DT-461**: Component Steps 21 - Process steps component
- **DT-460**: Photos-91 - Photo gallery component
- **DT-459**: Photos-90 - Photo gallery component
- **DT-422**: Photos-86 Component - Photo gallery layout
- **DT-416**: Skills-28 Component - Skills display
- **DT-414**: Basic-18 - Basic content block
- **DT-408**: Photos-85 Component - Photo gallery
- **DT-400**: Contact Component 15 & 16 - Contact form templates
- **DT-399**: Services-15 Component - Service template
- **DT-398**: Service Component 13 - Service display
- **DT-396**: Component Photos-84 - Photo gallery
- **DT-393**: Photo Components (James) - Multiple photo layouts
- **DT-392**: Photo Components - Additional photo templates
- **DT-389**: Service Components (Neil) - Service templates
- **DT-374**: New Service-10 Component - Service display
- **DT-334**: Bootstrap Component - Bootstrap-styled blocks

#### New Sections (Designs)
- **DT-486**: Section Banner-13 - Banner design
- **DT-529**: Section Banner-18 - Banner layout
- **DT-534**: Section Photos-15 - Photo section
- **DT-531**: Section Photos-17 - Photo gallery section
- **DT-527**: Section Photos-87 - Photo display section
- **DT-526**: Section Banner-19 - Banner template
- **DT-532**: Section Photos-18 - Photo section layout
- **DT-501**: Section Banner-17 (Rainbow Divider) - Decorative banner with rainbow divider
- **DT-488**: Section Photos-14 - Photo gallery section
- **DT-486**: Banner-16 Wave Banner - Wave-styled banner
- **DT-482**: Section Photos-95 - Photo gallery
- **DT-405**: Section Products 20 - Product display
- **DT-481**: Section Products-19 - Product listing
- **DT-480**: Section Services-19 - Service section
- **DT-474**: Section Banner-15 - Banner design
- **DT-479**: Section Photos-94 - Photo section
- **DT-476**: Section Photos-93 - Photo gallery
- **DT-466**: Section Photos-92 - Photo display
- **DT-462**: Section Banners 11 & 12 - Multiple banner templates
- **DT-457**: Banner 10 - Banner component
- **DT-445**: Section Features-28 - Features display
- **DT-451**: Banner-08 & Banner-09 - Multiple banners
- **DT-447**: Section Headline Header-80 - Headline section
- **DT-442**: Banner 07 - Banner template
- **DT-441**: Features 27 - Feature section
- **DT-437**: Header-07 - Header layout
- **DT-423**: Section Steps-19 - Process steps section
- **DT-431**: CTA-02 Section - Call to action
- **DT-432**: CTA-01 Design - Call to action design
- **DT-430**: Feature 26 - Feature block
- **DT-424**: New Banner Components - Multiple banner layouts
- **DT-420**: Section Photos 16 - Photo section
- **DT-410**: Photos-86 Change To Section - Converted component to section
- **DT-409**: New Banner-03 Section - Banner layout
- **DT-387**: New Section Banner-01 Neil - Banner template
- **DT-388**: New Sections & Components Will - Multiple templates
- **DT-353**: New Header Section - Header template

#### New Layouts
- **Header-07**: New header layout template (97 lines)
- **Header-08**: New header layout template (50 lines)
- **Header-09**: New header layout template (69 lines)
- **Header-10**: New header layout template (102 lines)
- **DT-503**: Footer-01 Update - Updated footer layout
- **DT-425**: New Header 06 Layout - Header template
- **DT-419**: Footer Template Updates - Multiple footer improvements
- **DT-402**: Header Templates - New header layouts
- **DT-305**: Header & Footer Templates - Multiple header and footer templates

#### New Widgets & Features
- **DT-473**: Post/Project Widget Templates - Widget templates for displaying posts and projects
  - `src/Views/frontend/posts/style_1.blade.php` through `style_5.blade.php`
  - `src/Views/frontend/projects/style_1.blade.php` through `style_5.blade.php`
- **DT-446**: Menu Widget - Menu display widget
- **DT-439**: Projects & Posts Random Order - Added random ordering support
- **DT-309**: Posts/Projects Widget - Widget for post and project listings
- **DT-309**: Posts/Projects Widget Links - Widget link functionality
- **DT-366**: Gallery Builder - Image Updates - Gallery image management improvements

#### Asset & Build System
- **webpack.mix.js**: Added Laravel Mix configuration (17 lines) for modern asset compilation
- **DT-490**: Bootstrap Js 5.2.3 Upgrade - Upgraded to Bootstrap 5.2.3 for improved compatibility

#### Image & Asset Optimization
- Bulk resized and optimized all preview images across components, designs, and layouts
- Reduced preview file sizes while maintaining visual quality
- Optimized header preview images (reduced from ~100KB to ~60KB average)
- Optimized heading preview images (reduced from ~4KB to ~1.2KB average)
- Replaced CDN-based image URLs with generic placeholders using regex across all templates
- Created `.gitkeep` files in preview directories for version control

#### Form & Validation
- **DT-428**: Google ReCaptcha - Env to Settings - Moved ReCaptcha config from .env to settings
- **DT-417**: Google ReCaptcha - Implemented Google ReCaptcha v3 support
  - Added ReCaptcha to contact forms
  - Added ReCaptcha to review forms
  - Fixed footer errors in ReCaptcha implementation
- New Validation object to handle builder captcha functionality
- Updated contact form, form builder, and review form to use new JavaScript captcha functionality
- Fixed submit handler on Firefox for improved cross-browser compatibility

#### Styling & UI
- **DT-356**: XL Buttons - Extra-large button styles
- **DT-344**: Form Button Class - Standardized form button styling
- **DT-336**: Footer Updates - Footer styling improvements
- **DT-331**: Update Product Component - Product display enhancements
- **DT-332**: Image Pagination Styling - Improved pagination UI
- **DT-434**: Section Width - No Padding - Added no-padding section option
- **DT-313**: No-Index - SEO noindex support
- **DT-298**: Submit-Button - Submit button improvements

#### Performance & Caching
- **DT-296**: Component/Section Cache - Implemented 10-minute cache for component and section file lists
- **DT-248**: Column Classes - Responsive column class system

#### Code Quality & Architecture
- **DT-465**: Header-8 - Header implementation improvements
- **DT-260**: Editor Streamlining - Simplified editor interface
- **DT-266**: Slider / Image Manager - Improved media management
- **DT-246 & DT-256**: Code improvements and refinements
- **DT-246**: Slider Templates - Slider component templates
- **DT-272**: Image Tab Pagination - Paginated image browsing

### Changed
- **bongocdn Integration**: Merged bongocdn package directly into builder (6,065 file changes)
  - Consolidated CDN functionality into single package
  - Removed external CDN dependencies
  - Improved asset loading performance
- **Image Placeholders**: Replaced all CDN-based image URLs with generic placeholders
  - Used regex to update image locations across all builder designs and components
  - Ensures templates work without external dependencies
  - Improves template portability
- **Preview File Structure**: Reorganized preview image storage
  - Deleted old design and snippet preview files (2,258 deletions)
  - Cleaned up unused seeder preview images
  - Streamlined preview file management
- **Path Fixes**: Fixed broken asset paths for improved reliability
- **Code Cleanup**: Tidied up codebase, removed redundant code
- **Updated Forms**: Modernized contact and review forms with new captcha methods

### Removed
- **Deleted Old Seeders**: Removed unused seeder files to reduce package size
  - Removed 2,000+ preview images from `src/Seeders/component/preview/`
  - Removed legacy seeder data
  - Added `.gitkeep` files to maintain directory structure
- **Deleted CDN Images**: Removed CDN-based image files (2,157 deletions)
- **Old Preview Files**: Removed outdated design and snippet preview files

### Fixed
- **DT-417**: Google ReCaptcha footer errors - Fixed ReCaptcha display issues in footers
- **Firefox Compatibility**: Fixed submit handler compatibility issues on Firefox
- **DT-279**: PHP FPM Error - Resolved PHP-FPM configuration errors
- **Broken Paths**: Fixed asset path resolution issues

### Developer Experience
- Improved code organization and structure
- Better separation of concerns between components, designs, and layouts
- Enhanced build system with webpack.mix.js
- Optimized asset sizes for faster loading
- Comprehensive caching strategy for better performance

### Statistics
- **3,079 files changed** with 103,453 insertions and 1,210 deletions
- **2,258 preview files** removed and reorganized
- **200+ Blade templates** updated with improved HTML escaping
- **764+ pre-built blocks** (components, designs, layouts)
- **2,050 FontAwesome icons** available in icon library

## [2.0.62] - Prior Release

### Note
Version 2.0.62 was the previous stable release. Detailed history for versions prior to 3.0.0 is available in git logs. Run `git log 2.0.62..3.0.65` for complete commit history.

---

**Package**: `bongo/builder`
**Repository**: https://bitbucket.org/designtec/builder
**Private Composer Repository**: https://designtecpackages.co.uk
