﻿/**
 * @param $root
 */
function applyAnimation($root) {
    var n = 0;
    $root.find('.is-animated').each(function () {

        if ($(this).data('animated') != 'done') {

            if (n > 0) $(this).css('animation-delay', n + 's');
            n = n + 0.2;

            $(this).removeClass('fadeOut');

            if ($(this).hasClass('is-pulse')) $(this).addClass('pulse');
            if ($(this).hasClass('is-bounceIn')) $(this).addClass('bounceIn');
            if ($(this).hasClass('is-fadeIn')) $(this).addClass('fadeIn');
            if ($(this).hasClass('is-fadeInDown')) $(this).addClass('fadeInDown');
            if ($(this).hasClass('is-fadeInLeft')) $(this).addClass('fadeInLeft');
            if ($(this).hasClass('is-fadeInRight')) $(this).addClass('fadeInRight');
            if ($(this).hasClass('is-fadeInUp')) $(this).addClass('fadeInUp');
            if ($(this).hasClass('is-flipInX')) $(this).addClass('flipInX');
            if ($(this).hasClass('is-flipInY')) $(this).addClass('flipInY');
            if ($(this).hasClass('is-slideInUp')) $(this).addClass('slideInUp');
            if ($(this).hasClass('is-slideInDown')) $(this).addClass('slideInDown');
            if ($(this).hasClass('is-slideInLeft')) $(this).addClass('slideInLeft');
            if ($(this).hasClass('is-slideInRight')) $(this).addClass('slideInRight');
            if ($(this).hasClass('is-zoomIn')) $(this).addClass('zoomIn');

            if ($(this).hasClass('once')) $(this).data('animated', 'done');
        }

    });
}

/**
 * @param $root
 */
function removeAnimation($root) {
    $root.find('.is-animated').each(function () {

        //$(this).removeClass('animated');
        $(this).removeClass('pulse');
        $(this).removeClass('bounceIn');
        $(this).removeClass('fadeIn');
        $(this).removeClass('fadeInDown');
        $(this).removeClass('fadeInLeft');
        $(this).removeClass('fadeInRight');
        $(this).removeClass('fadeInUp');
        $(this).removeClass('flipInX');
        $(this).removeClass('flipInY');
        $(this).removeClass('slideInUp');
        $(this).removeClass('slideInDown');
        $(this).removeClass('slideInLeft');
        $(this).removeClass('slideInRight');
        $(this).removeClass('zoomIn');

        if (!$(this).hasClass('once')) {
            $(this).addClass('fadeOut');
        }
    });
}

/**
 * @param $section
 */
function applyAnimationSection($section) {
    /*
    try {
        var s = $('.is-wrapper').data('contentbox').settings;
        //return;
    } catch (e) { }
    */

    var n = 0;

    if ($section.hasClass('is-animated')) {

        if ($section.data('animated') != 'done') {

            if(n>0) $section.css('animation-delay', n + 's');
            n = n + 0.2;

            $section.removeClass('fadeOut');

            if ($section.hasClass('is-pulse')) $section.addClass('pulse');
            if ($section.hasClass('is-bounceIn')) $section.addClass('bounceIn');
            if ($section.hasClass('is-fadeIn')) $section.addClass('fadeIn');
            if ($section.hasClass('is-fadeInDown')) $section.addClass('fadeInDown');
            if ($section.hasClass('is-fadeInLeft')) $section.addClass('fadeInLeft');
            if ($section.hasClass('is-fadeInRight')) $section.addClass('fadeInRight');
            if ($section.hasClass('is-fadeInUp')) $section.addClass('fadeInUp');
            if ($section.hasClass('is-flipInX')) $section.addClass('flipInX');
            if ($section.hasClass('is-flipInY')) $section.addClass('flipInY');
            if ($section.hasClass('is-slideInUp')) $section.addClass('slideInUp');
            if ($section.hasClass('is-slideInDown')) $section.addClass('slideInDown');
            if ($section.hasClass('is-slideInLeft')) $section.addClass('slideInLeft');
            if ($section.hasClass('is-slideInRight')) $section.addClass('slideInRight');
            if ($section.hasClass('is-zoomIn')) $section.addClass('zoomIn');

            if ($section.hasClass('once')) $section.data('animated', 'done');

        }
    }

    $section.find('.is-box.is-animated').each(function () {

        if ($(this).data('animated') != 'done') {

            if(n>0) $(this).css('animation-delay', n + 's');
            n = n + 0.2;

            $(this).removeClass('fadeOut');

            if ($(this).hasClass('is-pulse')) $(this).addClass('pulse');
            if ($(this).hasClass('is-bounceIn')) $(this).addClass('bounceIn');
            if ($(this).hasClass('is-fadeIn')) $(this).addClass('fadeIn');
            if ($(this).hasClass('is-fadeInDown')) $(this).addClass('fadeInDown');
            if ($(this).hasClass('is-fadeInLeft')) $(this).addClass('fadeInLeft');
            if ($(this).hasClass('is-fadeInRight')) $(this).addClass('fadeInRight');
            if ($(this).hasClass('is-fadeInUp')) $(this).addClass('fadeInUp');
            if ($(this).hasClass('is-flipInX')) $(this).addClass('flipInX');
            if ($(this).hasClass('is-flipInY')) $(this).addClass('flipInY');
            if ($(this).hasClass('is-slideInUp')) $(this).addClass('slideInUp');
            if ($(this).hasClass('is-slideInDown')) $(this).addClass('slideInDown');
            if ($(this).hasClass('is-slideInLeft')) $(this).addClass('slideInLeft');
            if ($(this).hasClass('is-slideInRight')) $(this).addClass('slideInRight');
            if ($(this).hasClass('is-zoomIn')) $(this).addClass('zoomIn');

            if ($(this).hasClass('once')) $(this).data('animated', 'done');
        }
    });
}

/**
 * @param $section
 */
function removeAnimationSection($section) {

    if ($section.hasClass('is-animated')) {

        $section.removeClass('pulse');
        $section.removeClass('bounceIn');
        $section.removeClass('fadeIn');
        $section.removeClass('fadeInDown');
        $section.removeClass('fadeInLeft');
        $section.removeClass('fadeInRight');
        $section.removeClass('fadeInUp');
        $section.removeClass('flipInX');
        $section.removeClass('flipInY');
        $section.removeClass('slideInUp');
        $section.removeClass('slideInDown');
        $section.removeClass('slideInLeft');
        $section.removeClass('slideInRight');
        $section.removeClass('zoomIn');

        if (!$section.hasClass('once')) {
            $section.addClass('fadeOut');
        }
    }

    $section.find('.is-animated').each(function () {

        $(this).removeClass('pulse');
        $(this).removeClass('bounceIn');
        $(this).removeClass('fadeIn');
        $(this).removeClass('fadeInDown');
        $(this).removeClass('fadeInLeft');
        $(this).removeClass('fadeInRight');
        $(this).removeClass('fadeInUp');
        $(this).removeClass('flipInX');
        $(this).removeClass('flipInY');
        $(this).removeClass('slideInUp');
        $(this).removeClass('slideInDown');
        $(this).removeClass('slideInLeft');
        $(this).removeClass('slideInRight');
        $(this).removeClass('zoomIn');

        if (!$(this).hasClass('once')) {
            $(this).addClass('fadeOut');
        }
    });
}

/**
 * Handle scroll down button
 */
function handleScrollDownBtn() {
    $('.is-arrow-down a').on('click', function (e) {
        let visibleChildren = $(this).parents(".is-section").nextAll('div:not(.is-hidden)');
        if (visibleChildren.html()) { /* .hidden class can be used as an exception */
            $('html,body').animate({
                scrollTop: visibleChildren.offset().top - parseInt($('.is-wrapper').css('padding-top')) /* + 1 Adjustment due to topbar height*/
            }, 800);
        }
        e.preventDefault();
        e.stopImmediatePropagation();
        return false;
    });
}

/**
 * Handle element animations
 */
function handleElementAnimations() {

    // Animate the first child
    $('.is-wrapper > div:first-child')
        .find('.is-scale-animated')
        .addClass('is-appeared');

    $('.is-scale-animated').appear();
    $('.is-scale-animated').on('appear', function () {
        $(this).addClass('is-appeared');
    });
    $('.is-scale-animated').on('disappear', function () {
        $(this).removeClass('is-appeared');
    });

    //Hide all animated elements first
    $('.is-animated').each(function () {
        $(this).addClass('animated');
        $(this).addClass('fadeOut');
    });
}

/**
 * Handle section animations
 */
function handleSectionAnimations() {

    /* Animate Section/Boxes */
    $('.is-section').appear();
    $('.is-section').each(function () {
        if ($(this).is(':appeared')) {
            applyAnimationSection($(this));
        }
    });
    if ($(window).scrollTop() == 0) {//on editing, appear not triggered on first load (on top only). This is the fix.
        setTimeout(applyAnimationSection($('.is-section').first()), 2000);
    }
    $('.is-section').on('appear', function () {
        applyAnimationSection($(this));
    });
    $('.is-section').on('disappear', function () {
        removeAnimationSection($(this));
    });
}

/**
 * Handle container animations
 */
function handleContainerAnimations() {

    /* Animate Content/Container */
    $('.is-container').appear();
    $('.is-container').each(function () {
        if ($(this).is(':appeared')) {
            applyAnimation($(this));
        }
    });
    if ($(window).scrollTop() == 0) {//on editing, appear not triggered on first load (on top only). This is the fix.
        $('.is-section').first().find('.is-container').each(function () {
            setTimeout(applyAnimation($(this)), 2000);
        });
    }
    $('.is-container').on('appear', function () {
        applyAnimation($(this));
    });
    $('.is-container').on('disappear', function () {
        removeAnimation($(this));
    });
}

/**
 * Handle the images that have call to actions
 */
function handleImageCtas() {

    // If we are in the editor then bail
    if (document.querySelector("#page-builder") || document.querySelector("#post-builder")) {
        return;
    }

    // Otherwise update the links
    $('img.has-cta').each(function () {
        let ctaTitle  = $(this).data('cta-title');
        let ctaUrl    = $(this).data('cta-url');
        let ctaTarget = $(this).data('cta-target');

        $(this).wrap(function() {
            return `<a class="d-block image-cta" href="${ctaUrl}" title="${ctaTitle}" target="${ctaTarget}"></a>`;
        });

        $(this).removeAttr('data-cta-title');
        $(this).removeAttr('data-cta-url');
        $(this).removeAttr('data-cta-target');
    });
}

/**
 * Load script
 *
 * @param url
 * @param callback
 */
function loadScript(url, callback) {

    var script = document.createElement("script")
    script.type = "text/javascript";

    if (script.readyState) {  //IE
        script.onreadystatechange = function () {
            if (script.readyState == "loaded" ||
                script.readyState == "complete") {
                script.onreadystatechange = null;
                callback();
            }
        };
    } else {  //Others
        script.onload = function () {
            callback();
        };
    }

    script.src = url;
    document.body.appendChild(script);
}

/**
 * Doc ready function
 */
$(document).ready(function (e) {
    handleScrollDownBtn();
    handleElementAnimations();
    handleSectionAnimations();
    handleContainerAnimations();

    handleImageCtas();
});

// Window load function
$(window).on('load', function () {

    // Handle aos
    AOS.init({duration: 1200});

    // Handle skrollr
    setTimeout(function () {
        skrollr.init({
            forceHeight: false,
            mobileCheck: function () { return false; },
            smoothScrolling: true,
            smoothScrollingDuration: 1500
        }).refresh();
    }, 100);

});
