<?php

use Bongo\Builder\Http\Controllers\Api\CarouselController;
use Bongo\Builder\Http\Controllers\Api\FormController;
use Bongo\Builder\Http\Controllers\Api\GalleryController;
use Bongo\Builder\Http\Controllers\Api\MenuController;
use Bongo\Builder\Http\Controllers\Api\PostController;
use Bongo\Builder\Http\Controllers\Api\ProjectController;
use Bongo\Builder\Http\Controllers\Api\ReviewController;
use Bongo\Builder\Http\Controllers\Api\ReviewSummaryController;
use Bongo\Builder\Http\Controllers\Api\SliderController;
use Bongo\Builder\Http\Controllers\Api\ValidationController;
use Illuminate\Support\Facades\Route;

/**
 * Custom API routes, publicly accessible
 */
Route::prefix(config('settings.api_prefix', 'api').'/')
    ->middleware(['noIndex'])
    ->as('api.')
    ->group(function () {

        Route::prefix('builder')
            ->as('builder.')
            ->group(function () {

                Route::get('carousels/{carousel}', [CarouselController::class, 'index'])
                    ->name('carousel.index');

                Route::get('sliders/{slider}', [SliderController::class, 'index'])
                    ->name('slider.index');

                Route::get('validation', [ValidationController::class, 'index'])
                    ->name('validation.index');

                Route::get('post', [PostController::class, 'index'])
                    ->name('post.index');

                Route::get('project', [ProjectController::class, 'index'])
                    ->name('project.index');

                Route::get('review', [ReviewController::class, 'index'])
                    ->name('review.index');

                Route::get('review-summary', [ReviewSummaryController::class, 'index'])
                    ->name('review_summary.index');

                Route::get('form-builder', [FormController::class, 'index'])
                    ->name('form_builder.index');

                Route::get('menu-builder', [MenuController::class, 'index'])
                    ->name('menu_builder.index');

                Route::get('gallery-builder', [GalleryController::class, 'index'])
                    ->name('gallery_builder.index');
            });

    });
