@php use Bongo\Gallery\Models\Gallery; @endphp
    <!DOCTYPE HTML>
<html>
    <head>
        <meta charset="utf-8">
        <title></title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <link rel="stylesheet" href="{{ config('builder.vendor_asset_path') }}/bootstrap.css">
        <link rel="stylesheet" href="{{ config('builder.backend_asset_path') }}/modules/css/settings.css">
    </head>
    <body>
        <div id="settings-wrapper">
            <div class="container">

                <div class="form-row w-100">
                    <div class="form-group col-12">
                        <label for="ref">Select Gallery:</label>
                        <select id="ref" class="form-control">
                            <option value="">-- Please Select --</option>
                            @foreach(Gallery::active()->get() as $gallery)
                                <option value="{{ $gallery->uuid }}">{{ $gallery->name }} - {{ $gallery->id }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-6">
                        <label for="columns">Columns:</label>
                        <select id="columns" class="form-control">
                            <option value="3">3 Columns</option>
                            <option value="4">4 Columns</option>
                            <option value="5">5 Columns</option>
                            <option value="6">6 Columns</option>
                        </select>
                    </div>

                    <div class="form-group col-6">
                        <label for="padding">Padding:</label>
                        <select id="padding" class="form-control">
                            <option value="0">None</option>
                            <option value="3">Small</option>
                            <option value="6">Medium</option>
                            <option value="12">Large</option>
                        </select>
                    </div>

                    <div class="form-group col-6">
                        <label for="preset">Preset:</label>
                        <select id="preset" class="form-control">
                            <option value="thumb">Thumbnail - 150px</option>
                            <option value="small">Small - 480px</option>
                            <option value="medium">Medium - 720px</option>
                            <option value="large">Large - 1600px</option>
                            <option value="full">Full - 1920px</option>
                        </select>
                    </div>

                    <div class="form-group col-6">
                        <label for="quality">Quality</label>
                        <input id="quality" class="form-control" type="text" value="80">
                    </div>
                </div>

                <div class="form-row w-100">
                    <div class="form-group col">
                        <label>
                            <input id="lazy" class="input-lazy" type="checkbox"/>
                            Lazy Load
                        </label>
                    </div>
                    <div class="form-group col">
                        <label>
                            <input id="lightbox" class="input-lightbox" type="checkbox"/>
                            Lightbox
                        </label>
                    </div>

                    <div class="form-group col-12">
                        <label for="class-list">Classes</label>
                        <textarea id="class-list" class="form-control" rows="2"></textarea>
                    </div>
                </div>

            </div>
        </div>

        <script src="{{ config('builder.backend_asset_path') }}/modules/js/gallery-builder.js"></script>
    </body>
</html>
