<?php

$id = Str::random(5);

$moduleHtml = '
    <div id="'.$id.'" class="gallery-builder"></div>

    <script>
        var '.$id.'_docReady = function (fn) {
            var stateCheck = setInterval(function () {
                if (document.readyState !== "complete") return;
                clearInterval(stateCheck);
                try {fn()} catch (e) {}
            }, 1000);
        };
        '.$id.'_docReady(function () {
            var xmlhttp = new XMLHttpRequest();
            xmlhttp.onreadystatechange = function() {
                if (xmlhttp.readyState === XMLHttpRequest.DONE) {
                    if (xmlhttp.status === 200) {
                        let galleryContainer = document.getElementById("'.$id.'");
                        galleryContainer.innerHTML = xmlhttp.responseText;
                    }
                }
            };
            xmlhttp.open("GET", "/api/builder/gallery-builder", true);
            xmlhttp.send();
        });
    </script>
';

$moduleSettings = '
    {
        "ref": "",
        "columns": "4",
        "padding": "0",
        "preset": "medium",
        "quality": "80",
        "lazy_load": false,
        "lightbox": false,
        "class_list": ""
    }
';
?>

<div class="row clearfix border-0">
    <div class="col-12"
         data-noedit
         data-module="gallery-builder"
         data-dialog-width="500px"
         data-module-desc="Gallery Builder"
         data-html="{{ encode_uri_component($moduleHtml) }}"
         data-settings="{{ encode_uri_component($moduleSettings) }}"
    >
    </div>
</div>
