<footer id="footer" class="footer-2" itemscope itemtype="http://schema.org/LocalBusiness">

    <div class="d-none" itemprop="image" itemscope itemtype="http://schema.org/ImageObject">
        <span itemprop="url" data-content="{{ setting('theme::logo.light') }}"></span>
    </div>

    <div class="container">
        <div class="row py-5">

            <div class="col-md-5 col-lg-3 mb-5 mb-lg-0"
                 itemscope
                 itemtype="http://schema.org/PostalAddress"
                 itemprop="address"
            >
                <h5 class="mb-4">Contact Details</h5>

                @if(!empty(setting('client::office.line_1')))
                    <p class="mb-1">
                        <span itemprop="streetAddress">
                            {{ setting('client::office.line_1') }}, {{ setting('client::office.line_2') }}
                        </span>
                    </p>
                @endif

                @if(!empty(setting('client::office.city')))
                    <p class="mb-4 pb-1">
                        <span itemprop="addressLocality">
                            {{ setting('client::office.city') }},
                        </span>
                        <span itemprop="postalCode">
                            {{ setting('client::office.postcode') }}
                        </span>
                    </p>
                @endif

                @if(setting()->getClientPhoneNumber())
                    <p class="mb-1 pt-2">
                        Call:
                        <a href="tel:{{ str_replace(' ', '', setting()->getClientPhoneNumber()) }}"
                           itemprop="telephone"
                           data-content="{{ setting()->getClientPhoneNumber() }}"
                        >
                            {{ setting()->getClientPhoneNumber() }}
                        </a>
                    </p>
                @endif

                @if(!empty(setting('client::company.email')))
                    <p class="mb-0">
                        Email:
                        <a href="mailto:{{ setting('client::company.email') }}" itemprop="email"
                           data-content="{{ setting('client::company.email') }}"
                        >
                            {{ setting('client::company.email') }}
                        </a>
                    </p>
                @endif
            </div>

            <div class="col-md-7 col-lg-5 mb-5 mb-lg-0 footer-menu">
                <h5 class="mb-4">Links</h5>
                @includeIf('menu::frontend.partials.footer_menu_2', ['key' => 'footer_menu'])
            </div>

            <div class="col-lg-4" id="mc_embed_signup">
                <h5 class="mb-4">Newsletter</h5>

                <form action="{{ setting('system::credentials.mailchimp_url') }}"
                      method="POST"
                      id="mc-embedded-subscribe-form"
                      name="mc-embedded-subscribe-form"
                      class="mw-100 validate"
                      novalidate="novalidate"
                      target="_blank"
                >

                    <div id="mc_embed_signup_scroll">

                        <div class="input-group">
                            <input id="mce-EMAIL"
                                   class="form-control required email"
                                   placeholder="Email Address..."
                                   name="EMAIL"
                                   type="text"
                            >
                            <div class="input-group-append">
                                <button id="mc-embedded-subscribe"
                                        class="btn btn-primary btn-submit"
                                        type="submit"
                                        name="subscribe"
                                        style="border-bottom-left-radius:0; border-top-left-radius:0;"
                                >
                                    Subscribe!
                                </button>
                            </div>
                        </div>

                        <div id="mce-responses" class="clear">
                            <div id="mce-error-response"
                                 class="response bg-red-300 mt-2 p-2 text-sm leading-5 text-red-800"
                                 style="display:none"
                            ></div>

                            <div id="mce-success-response"
                                 class="response bg-green-300 mt-2 p-2 text-sm leading-5 text-green-800"
                                 style="display:none"
                            ></div>
                        </div>

                        <!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->
                        <div style="position: absolute; left: -5000px;" aria-hidden="true">
                            <input type="text" name="b_b6c852b22f351d36fe475c5c4_173a09391f" tabindex="-1" value="">
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>

    <div class="footer-copyright">
        <div class="container">
            <div class="row py-3">
                <div class="col-12">
                    @if(! empty(setting('client::registered.line_1')))
                        <p class="m-2 d-flex justify-content-center flex-wrap">
                            @if(! empty(setting('client::company.name')))
                                <span class="d-block pe-1">
                                    {{ setting('client::company.name') }},
                                </span>
                            @endif
                            @if(! empty(setting('client::company.company_number')))
                                <span class="d-block pe-1">
                                    Company No: {{ setting('client::company.company_number') }},
                                </span>
                                <span class="d-block pe-1">Registered in England &amp; Wales.</span>
                            @endif
                            @if(! empty(setting('client::registered.line_1')))
                                <span class="d-block pe-1">
                                    {{ setting('client::registered.line_1') }},
                                </span>
                            @endif
                            @if(! empty(setting('client::registered.line_2')))
                                <span class="d-block pe-1">
                                    {{ setting('client::registered.line_2') }},
                                </span>
                            @endif
                            @if(! empty(setting('client::registered.city')))
                                <span class="d-block pe-1">
                                    {{ setting('client::registered.city') }},
                                </span>
                            @endif
                            @if(! empty(setting('client::registered.postcode')))
                                <span class="d-block">
                                    {{ setting('client::registered.postcode') }}.
                                </span>
                            @endif
                        </p>
                    @endif
                </div>

                <div class="col-lg-12 d-flex align-items-center justify-content-center mb-4 mb-lg-0">
                    <p>
                        &copy;{{ now()->format('Y') }}
                        <span itemprop="name">{{ setting('client::company.name') }}</span>
                        . All rights reserved.
                        <a href="{{ setting('system::developer.credit_link') }}" {{ setting()->isNoFollow() ? 'rel=nofollow' : '' }}>
                            {{ setting('system::developer.credit_text') }}
                        </a>
                    </p>
                </div>

            </div>
        </div>
    </div>
</footer>

@section('footer_javascript')
    @parent
    <script type='text/javascript' src='//s3.amazonaws.com/downloads.mailchimp.com/js/mc-validate.js'></script>
    <script type='text/javascript'>
        (function ($) {
            window.fnames = [];
            window.ftypes = [];
            fnames[0] = 'EMAIL';
            ftypes[0] = 'email';
            fnames[1] = 'FNAME';
            ftypes[1] = 'text';
            fnames[2] = 'LNAME';
            ftypes[2] = 'text';
            fnames[3] = 'ADDRESS';
            ftypes[3] = 'address';
            fnames[4] = 'PHONE';
            ftypes[4] = 'phone';
            fnames[5] = 'BIRTHDAY';
            ftypes[5] = 'birthday';
        }(jQuery));
        var $mcj = jQuery.noConflict(true);
    </script>
@endsection
