<header
    id="header"
    class="header-4 @yield('header_class', setting()->getHeaderClass())"
    itemscope
    itemtype="http://schema.org/LocalBusiness"
>

    {{-- Header Top --}}
    <div class="header-top">
        <div class="container">
            <div class="row">

                {{-- Header Top Left --}}
                <div class="col-12 col-lg-6 header-top-left d-none d-md-flex align-items-center">
                    <nav class="sub-navbar">
                        <ul>
                            @includeIf('menu::frontend.partials.top_menu', ['key' => 'top_menu'])
                        </ul>
                    </nav>
                </div>

                {{-- Header Top Right --}}
                <div
                    class="col-12 col-lg-6 header-top-right d-flex align-items-center justify-content-center justify-content-md-end"
                >
                    <nav class="sub-navbar">
                        <ul>
                            @if(setting()->getClientPhoneNumber())
                                <li class="nav-item">
                                    <a href="tel:{{ str_replace(' ', '', setting()->getClientPhoneNumber()) }}"
                                       itemprop="telephone"
                                       data-content="{{ setting()->getClientPhoneNumber() }}"
                                    >
                                        <i class="fas fa-phone text-primary"></i>
                                        {{ setting()->getClientPhoneNumber() }}
                                    </a>
                                </li>
                            @endif
                            @if(!empty(setting('client::company.email')))
                                <li class="nav-item d-none d-md-inline-block">
                                    <a href="mailto:{{ setting('client::company.email') }}"
                                       itemprop="email"
                                       data-content="{{ setting('client::company.email') }}"
                                    >
                                        <i class="fas fa-envelope text-primary"></i>
                                        {{ setting('client::company.email') }}
                                    </a>
                                </li>
                            @endif
                        </ul>
                    </nav>
                </div>

            </div>
        </div>
    </div>

    {{-- Header Middle--}}
    <div class="header-middle">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-2 col-xl-3 d-flex align-items-center">

                    {{-- Logo --}}
                    <a class="navbar-brand"
                       href="{{ url('/') }}"
                       itemprop="image" itemscope
                       itemtype="http://schema.org/ImageObject"
                    >
                        <img class="header-logo"
                             alt="{{ setting('client::company.name') }}"
                             src="{{ setting('theme::logo.default') }}"
                             itemprop="url"
                             data-content="{{ setting('theme::logo.default') }}"
                        >
                    </a>

                    {{-- Main Menu --}}

                    {{-- Burger Menu --}}
                    <button class="navbar-toggler d-lg-none"
                            type="button"
                            data-bs-toggle="collapse"
                            data-bs-target="#navbarNavDropdown"
                            aria-controls="navbarNavDropdown"
                            aria-expanded="false"
                            aria-label="Toggle navigation"
                    >
                        <i class="fas fa-bars"></i>
                    </button>

                </div>
                <div class="col-12 col-lg-10 col-xl-9 d-lg-flex align-items-center justify-content-end">

                    <nav class="navbar navbar-expand-lg">
                        <div class="collapse navbar-collapse justify-content-end" id="navbarNavDropdown">
                            <ul class="navbar-nav">
                                @include('menu::frontend.partials.main_menu', ['key' => 'main_menu'])
                            </ul>
                        </div>

                    </nav>
                </div>
            </div>

        </div>
    </div>

</header>
