@if(! empty($posts))
    <div class="grid grid-cols-{{ $columns ?? 3 }} gap-{{ $padding ?? 3 }} {{ $style ?? '' }}">
        @foreach($posts as $post)
            <div class="grid-item">

                <article class="post card">

                    <div class="card-image">
                        <a class="card-link d-block" href="{{ route('frontend.post.show', $post->slug) }}">
                            @if($image = $post->primaryImage())
                                <img class="image {{ $lazy ? 'lazyload' : '' }}"
                                     src="{!! route('frontend.image.show', ['image' => $image, 'preset' => 'medium', 'q' => ($lazy ? '5' : config('image.quality'))]) !!}"
                                     data-src="{!! route('frontend.image.show', ['image' => $image, 'preset' => 'medium']) !!}"
                                     alt="{{ $image->title ?? $post->name }}"
                                     loading="{{ $lazy ? 'lazy' : 'null' }}"
                                />
                            @else
                                <img
                                    class="image"
                                    src="{{ $post->getPlaceholder(['preset' => 'medium']) }}"
                                    alt="{{ $post->name }}"
                                />
                            @endif
                        </a>
                    </div>

                    <div class="card-body">
                        <h5 class="card-title">
                            <a class="card-link" href="{{ route('frontend.post.show', $post->slug) }}">
                                {{ $post->name }}
                            </a>
                        </h5>

                        @if($showSummary)
                            <p class="card-text">
                                {!! str($post->summary)->limit($characters) !!}
                            </p>
                        @endif
                    </div>

                    @if($showButton)
                        <div class="card-footer">
                            <a class="card-link btn btn-primary" href="{{ route('frontend.post.show', $post->slug) }}">
                                Read More
                            </a>
                        </div>
                    @endif
                </article>

            </div>
        @endforeach
    </div>
@else
    <div class="border rounded text-center p-4 bg-white">
        <p class="text-muted text-uppercase m-0">POSTS NOT FOUND...</p>
    </div>
@endif
