﻿/**
 * Button Editor Plugin
 */
(function () {

    // Html for the iframe window
    var html = `
        <div class="is-modal buttoneditor">
            <div style="width:505px; height:420px; background:#fff; position: relative; display: flex; flex-direction: column; align-items: center; padding: 0px;">
                <div class="is-modal-bar is-draggable" style="width: 100%;">
                    ${ _cb.out('Button Editor')}
                    <div class="is-modal-close">&#10005;</div>
                </div>                
                <iframe data-width="1440" 
                        style="width:100%; height:100%; max-width:1440px; border:none; margin:0; box-sizing:border-box; background:#fff;" 
                        src="about:blank"
                ></iframe>
            </div>
        </div>
    `;

    // Add the html to the builder
    _cb.addHtml(html);

    // Html for the edit button
    var html_button = `
        <button title="${_cb.out('Edit Button')}" 
                data-title="${_cb.out('Edit Button')}" 
                class="button-edit" 
                style="display:none;"
        >
            <svg class="is-icon-flex" style="width:13px; height:13px;">
                <use xlink:href="#ion-android-create"></use>
            </svg>
        </button>
    `;

    // Find the link tool and add the button to the start
    var linkTool = document.querySelector('#divLinkTool');
    linkTool.insertAdjacentHTML('afterBegin', html_button);

    // Get the new button
    var buttonEdit = linkTool.querySelector('.button-edit');

    // Extend onContentClick
    var oldget = _cb.opts.onContentClick;
    _cb.opts.onContentClick = function (e) {

        let elm        = e.target;
        var ret        = oldget.apply(this, arguments);
        var elmDisplay = getStyle(elm, 'display');

        // If this is a link and not a button the show the edit button
        if (elm.tagName.toLowerCase() === 'a'
            && elm.classList
            && elm.classList.contains('btn')
        ) {
            buttonEdit.style.display = 'block';
        } else {
            buttonEdit.style.display = 'none';
        }

        return ret;
    };

    // Helper for getting the style tag contents
    var getStyle = function (element, property) {
        return window.getComputedStyle
            ? window.getComputedStyle(element, null).getPropertyValue(property)
            : element.style[property.replace(/-([a-z])/g, function (g) {
                return g[1].toUpperCase();
            })];
    }

    // Event handler for the new button
    buttonEdit.addEventListener('click', function () {

        // Show the edit button modal & save current state
        var modal = document.querySelector('.is-modal.buttoneditor');
        _cb.showModal(modal);
        _cb.saveForUndo(true);

        // Listen for the user closing the modal
        var btnClose = modal.querySelector('.is-modal-close');
        btnClose.addEventListener('click', function (e) {
            _cb.hideModal(modal);
        });

        modal.querySelector('iframe').src = _cb.opts.buttonSelect;
    });

})();

