function getParent() {
    return parent;
}

function convertHtmlToBootstrap(html) {

    // Replace row
    html = html.replace(new RegExp('row clearfix', 'g'), 'row');

    // Replace columns
    html = html.replace(new RegExp('column full', 'g'), 'col-md-12');
    html = html.replace(new RegExp('column half', 'g'), 'col-md-6');
    html = html.replace(new RegExp('column third', 'g'), 'col-md-4');
    html = html.replace(new RegExp('column fourth', 'g'), 'col-md-3');
    html = html.replace(new RegExp('column fifth', 'g'), 'col-md-2');
    html = html.replace(new RegExp('column sixth', 'g'), 'col-md-2');
    html = html.replace(new RegExp('column two-third', 'g'), 'col-md-8');
    html = html.replace(new RegExp('column two-fourth', 'g'), 'col-md-9');
    html = html.replace(new RegExp('column two-sixth', 'g'), 'col-md-10');

    return html;
}

function makeId() {

    var text     = "";
    var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    for (var i = 0; i < 2; i++) {
        text += possible.charAt(Math.floor(Math.random() * possible.length));
    }

    var text2     = "";
    var possible2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    for (var i = 0; i < 5; i++) {
        text2 += possible2.charAt(Math.floor(Math.random() * possible2.length));
    }

    return text + text2;
}

jQuery(document).ready(function ($) {

    jQuery(document)
        .off('click', '.is-pop-close')
        .on('click', '.is-pop-close', function () {
            let modal = parent.document.querySelector('.is-modal.snippets');
            modal.classList.remove('active');
        });

    // Click event handler for the item
    jQuery(document)
        .off('click', '.is-design-list > div')
        .on('click', '.is-design-list > div', function () {

            // Get the html from the item
            let html = jQuery(this).attr('data-html');
            html = JSON.parse(html);
            html = convertHtmlToBootstrap(html);

            // If the html from the item has an id placeholder then replace it with a random id
            html = html.replace(/{id}/g, makeId());

            // Add the parsed html to content box
            let notEditable = html.indexOf('noedit') === -1;
            getParent()._cb.addSnippet(html, false, notEditable);

            // Hide the modal
            let modal = parent.document.querySelector('.is-modal.snippets');
            modal.classList.remove('active');
        });
});