
var imagePath = '/frontend/styles/images';

/**
 * Shared variables
 */
var categories    = jsonStyles.data.categories;
var defaultcat    = '';
var defaultcatval = -1;
var catoptions    = '';

for (var i = 0; i < categories.length; i++) {
    catoptions += '<div data-value="' + categories[i].id + '">' + out(categories[i].desc) + '</div>';
    if (categories[i].id === defaultcatval) defaultcat = out(categories[i].desc);
}

var html = '<div class="is-selectbox style-cat" data-group="style-cat" data-value="' + defaultcatval + '">' +
    '<span>' + defaultcat + '</span>' +
    '<svg class="is-icon-flex" style="position:absolute;top:13px;right:10px;"><use xlink:href="#ion-android-arrow-dropdown"></use></svg>' +
    '</div>' +
    '<div class="is-selectbox-options style-cat-options" data-group="style-cat" style="display:none">' +
    catoptions +
    '</div>';

var selector       = document.querySelector('#divSelector');
selector.innerHTML = html;

parent._cb.dropdown(document.querySelector('.style-cat'), {
    dropdown : document.querySelector('.style-cat-options'),
    onChange : function (value) {

        var catid = value;

        var styles = jsonStyles.data.styles;

        if (catid == -1) {
            //show all
            var html = '';
            for (var i = 0; i < styles.length; i++) {
                html += '<div data-css="' + styles[i].css + '" data-sectioncss="' + styles[i].sectioncss + '" data-classname="' + styles[i].classname + '">' +
                    '<div>[' + (i + 1) + '] ' + styles[i].caption + '</div>' +
                    '<img src="' + styles[i].img + '" /></div>';
            }
        } else {
            //show based on category
            var html = '';
            for (var i = 0; i < styles.length; i++) {
                if (catid == styles[i].category) {
                    html += '<div data-css="' + styles[i].css + '" data-sectioncss="' + styles[i].sectioncss + '" data-classname="' + styles[i].classname + '">' +
                        '<div>[' + (i + 1) + '] ' + styles[i].caption + '</div>' +
                        '<img src="' + styles[i].img + '" /></div>';
                }
            }
        }
        html += '<div data-css="" data-sectioncss="" data-classname=""><img src="' + imagePath + '/_clear.jpg" /></div>';
        var selection       = document.querySelector('#divStyles');
        selection.innerHTML = html;

        var elms = elementChildren(selection);
        elms.forEach(function (elm) {
            elm.addEventListener('click', function (elm) {

                parent.applyTypography(this.getAttribute('data-classname'), this.getAttribute('data-sectioncss'), this.getAttribute('data-css'));

            });
        });

    }
});

var styles    = jsonStyles.data.styles;
var stylehtml = '';
for (var i = 0; i < styles.length; i++) {
    stylehtml += '<div data-css="' + styles[i].css + '" data-sectioncss="' + styles[i].sectioncss + '" data-classname="' + styles[i].classname + '"><div>[' + (i + 1) + '] ' + styles[i].caption + '</div><img src="' + imagePath + '/' + styles[i].img + '" /></div>';
}
stylehtml += '<div data-css="" data-sectioncss="" data-classname=""><img src="' + imagePath + '/_clear.jpg" /></div>';
var selection       = document.querySelector('#divStyles');
selection.innerHTML = stylehtml;

var elms = elementChildren(selection);
elms.forEach(function (elm) {
    elm.addEventListener('click', function (elm) {
        parent.applyTypography(this.getAttribute('data-classname'), this.getAttribute('data-sectioncss'), this.getAttribute('data-css'));
    });
});


document.addEventListener('click', function (e) {
    e          = e || window.event;
    var target = e.target || e.srcElement;

    let k       = false;
    let element = target;
    while (element) {
        if (!element.tagName) break;
        if (element.tagName === 'BODY' || element.tagName === 'HTML') break;

        if (hasClass(element, 'is-selectbox') || hasClass(element, 'is-selectbox-options')) k = true; // dropdown

        element = element.parentNode;
    }

    // dropdown
    if (!k) {
        let dropdowns = document.querySelectorAll('.is-selectbox-options');
        Array.prototype.forEach.call(dropdowns, function (dropdown) {
            dropdown.style.display = 'none';
        });
    }
});

parent.document.addEventListener('click', function (e) {

    let dropdowns = document.querySelectorAll('.is-selectbox-options');
    Array.prototype.forEach.call(dropdowns, function (dropdown) {
        dropdown.style.display = 'none';
    });

});

/**
 *
 * @param element
 * @param classname
 * @returns {boolean}
 */
function hasClass(element, classname) {
    if (!element) return false;
    try {
        let s = element.getAttribute('class');
        return new RegExp('\\b' + classname + '\\b').test(s);
    } catch (e) {
        0;
    }
}

/**
 *
 * @param element
 * @returns {[]}
 */
function elementChildren(element) {
    const childNodes = element.childNodes;
    let children     = [];
    let i            = childNodes.length;
    while (i--) {
        if (childNodes[i].nodeType === 1 /*&& childNodes[i].tagName === 'DIV'*/) {
            children.unshift(childNodes[i]);
        }
    }
    return children;
}

var bLangFile = false;
if (typeof parent._txt !== 'undefined') {
    bLangFile = true;
}

/**
 *
 * @param s
 * @returns {*}
 */
function out(s) {
    if (bLangFile) {
        var result = parent._txt[s];
        if (result) return result;
        else return s;
    } else {
        return s;
    }
}
