<?php

namespace Bongo\Builder\Http\Middleware;

use Bongo\Framework\Helpers\ShortCode;
use Closure;
use Illuminate\Contracts\Container\BindingResolutionException;

class HasShortCodes
{
    /**
     * @throws BindingResolutionException
     */
    public function handle($request, Closure $next)
    {
        // Get the next response and see if it has any html content or bail
        $response = $next($request);
        if (! method_exists($response, 'content')) {
            return $response;
        }

        // Check if the html contains shortcodes and if it does replace them
        $content = ShortCode::parse($response->content());

        // Update the response and return
        $response->setContent($content);

        return $response;
    }
}
