<?php

use Bongo\Builder\Http\Controllers\Backend\ComponentController;
use Bongo\Builder\Http\Controllers\Backend\DesignController;
use Bongo\Builder\Http\Controllers\Backend\IconController;
use Bongo\Builder\Http\Controllers\Backend\LayoutController;
use Illuminate\Support\Facades\Route;

Route::as('component.')
    ->prefix(config('builder.component_prefix'))
    ->group(function () {
        Route::get('/', [ComponentController::class, 'index'])
            ->name('index');

        Route::get('create', [ComponentController::class, 'create'])
            ->name('create');

        Route::post('store', [ComponentController::class, 'store'])
            ->name('store');

        // Component/{key}/
        Route::prefix('{key}')
            ->group(function () {
                Route::get('/', [ComponentController::class, 'show'])
                    ->name('show');

                Route::get('edit', [ComponentController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [ComponentController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [ComponentController::class, 'destroy'])
                    ->name('destroy');
            });
    });

Route::as('design.')
    ->prefix(config('builder.design_prefix'))
    ->group(function () {

        Route::get('/', [DesignController::class, 'index'])
            ->name('index');

        Route::get('create', [DesignController::class, 'create'])
            ->name('create');

        Route::post('store', [DesignController::class, 'store'])
            ->name('store');

        // Design/{key}/
        Route::prefix('{key}')
            ->group(function () {
                Route::get('/', [DesignController::class, 'show'])
                    ->name('show');

                Route::get('edit', [DesignController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [DesignController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [DesignController::class, 'destroy'])
                    ->name('destroy');
            });
    });

Route::as('layout.')
    ->prefix(config('builder.layout_prefix'))
    ->group(function () {

        Route::get('/', [LayoutController::class, 'index'])
            ->name('index');

        Route::get('create', [LayoutController::class, 'create'])
            ->name('create');

        Route::post('store', [LayoutController::class, 'store'])
            ->name('store');

        // Layout/{key}/
        Route::prefix('{key}')
            ->group(function () {
                Route::get('/', [LayoutController::class, 'show'])
                    ->name('show');

                Route::get('edit', [LayoutController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [LayoutController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [LayoutController::class, 'destroy'])
                    ->name('destroy');
            });
    });

Route::as('icon.')
    ->prefix('/icons')
    ->group(function () {
        Route::get('/', [IconController::class, 'index'])
            ->name('index');
    });
