@extends('framework::backend.layouts.app')

@section('content')
    @component('blade::content_header')
        {{ trans('builder::backend.layout_index') }}
        @slot('actions')
            @backButton(['name' => trans('builder::backend.layout_index')])
            @createButton(['name' => trans('builder::backend.layout_create'), 'url' => route('backend.layout.create')])
        @endslot
    @endcomponent

    @component('blade::content_body')
        @if($categories && count($categories) > 0)
            <div>
                <div
                    class="px-4 mb-6 bg-white shadow sm:px-6 sm:block sm:rounded-bl-sm sm:rounded-br-sm border-t border-gray-100"
                >
                    <nav class="flex flex-wrap -mb-px">
                        @foreach($categories as $key => $category)
                            @if(request()->get('category', 'footers') === $key)
                                <a href="{{ route('backend.layout.index', ['category' => $key]) }}"
                                   class="group inline-flex items-center py-3 px-1 mr-8 border-b-2 font-medium text-sm leading-5 focus:outline-none border-gray-500 text-gray-600 focus:text-gray-800 focus:border-gray-700"
                                >
                                    <span>{{ ucwords(str_replace('_', ' ', $category)) }}</span>
                                </a>
                            @else
                                <a href="{{ route('backend.layout.index', ['category' => $key]) }}"
                                   class="group inline-flex items-center py-3 px-1 mr-8 border-b-2 font-medium text-sm leading-5 focus:outline-none border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 focus:text-gray-700 focus:border-gray-300"
                                >
                                    <span>{{ ucwords(str_replace('_', ' ', $category)) }}</span>
                                </a>
                            @endif
                        @endforeach
                    </nav>
                </div>

                <div class="tabs-container">
                    <div class="grid md:grid-cols-3 lg:grid-cols-6 gap-3">
                        @foreach($layouts as $layout)

                            <a href="{{ route('backend.layout.show', $layout->key) }}"
                               class="block group"
                               title="Edit layout"
                               aria-label="Edit layout"
                               v-tooltip='"Click here to <b>edit layout</b>"'
                            >
                                <div class="w-full border border-solid border-light-700 group-hover:border-primary-500">
                                    <img class="lazyload" src="{{ $layout->getThumbnail() }}" alt="Layout Preview"
                                         loading="lazy"
                                    >
                                </div>
                                <div class="mt-1 ml-1">
                                    <span
                                        class="text-sm text-gray-400 font-semibold leading-snug truncate group-hover:text-primary-500"
                                    >
                                        {{ ucwords($layout->name) }}
                                    </span>
                                </div>
                            </a>

                        @endforeach
                    </div>
                </div>
            </div>
        @else
            @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                <div class="message text-center">
                    <div class="message-text font-semibold">
                        No layouts found, please check directory contents
                    </div>
                </div>
            @endcomponent
        @endif
    @endcomponent
@stop
