<footer id="footer" class="footer-5 container-fluid border-top-0" itemscope itemtype="http://schema.org/LocalBusiness">
    <div class="d-none" itemprop="image" itemscope itemtype="http://schema.org/ImageObject">
        <span itemprop="url" data-content="{{ setting('theme::logo.light') }}"></span>
    </div>

    <div class="row">

        <div class="col-lg-6 p-0">
            <section class="section h-100 m-0">

                <div class="section-row">
                    <div class="section-col section-col-left">

                        <p class="mb-0 pb-0">
                            LET'S TALK ABOUT YOUR PROJECT
                        </p>

                        <h2 class="mb-3 text-lg">Send us a Message</h2>
                        <form
                            id="footer-05-form"
                            class="contact-form has-captcha"
                            action="{{ route('frontend.enquiry.store') }}"
                            method="POST"
                        >
                            <div class="validation {{ uniqid('v-') }}">
                                @csrf
                                @honeypot
                                @if(setting()->reCaptchaEnabled())
                                    {!! captcha()->field('enquiry') !!}
                                @endif
                            </div>

                            <div class="form-row">
                                <div class="form-group col-lg-6 pr-lg-2">
                                    <input class="form-control py-2"
                                           name="name"
                                           maxlength="100"
                                           type="text"
                                           value="{{ old('name') }}"
                                           data-msg-required="Please enter your name."
                                           placeholder="Your Name..."
                                           required
                                    >
                                </div>

                                <div class="form-group col-lg-6 pl-lg-2">
                                    <input class="form-control py-2"
                                           name="phone"
                                           maxlength="100"
                                           type="text"
                                           value="{{ old('phone') }}"
                                           data-msg-required="Please enter your phone."
                                           placeholder="Your Phone..."
                                           required
                                    >
                                </div>
                            </div>

                            <div class="form-group">
                                <input class="form-control py-2"
                                       name="email"
                                       maxlength="100"
                                       type="email"
                                       value="{{ old('email') }}"
                                       data-msg-required="Please enter your email address."
                                       data-msg-email="Please enter a valid email address."
                                       placeholder="Your Email Address..."
                                       required
                                >
                            </div>

                            <div class="form-row">
                                <div class="form-group col">
                                    <textarea class="form-control"
                                              name="message"
                                              maxlength="5000"
                                              rows="4"
                                              data-msg-required="Please enter your message."
                                              placeholder="Your Message..."
                                              required
                                    >{{ old('message') }}</textarea>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col">
                                    <input class="btn btn-primary btn-submit"
                                           type="submit" value="Submit"
                                           data-loading-text="Loading..."
                                    >
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </section>
        </div>

        <div class="col-lg-6 p-0">
            <section class="section bg-primary h-100 m-0">

                <div class="section-row">
                    <div class="section-col section-col-right">

                        <p class="mb-0 pb-0">
                            TALK TO A SPECIALIST
                        </p>
                        <h2 class="mb-3 text-lg">Let's talk business</h2>

                        @if(!empty(setting('theme::layout.footer_text')))
                            <p class="footer-text">
                                {{ setting('theme::layout.footer_text') }}
                            </p>
                        @endif

                        @if(setting()->getClientPhoneNumber())
                            <p class="mb-0 pb-0">
                                Call Us Now
                            </p>
                            <a href="tel:{{ str_replace(' ', '', setting()->getClientPhoneNumber()) }}"
                               class="footer-phone"
                               itemprop="telephone"
                               data-content="{{ setting()->getClientPhoneNumber() }}"
                            >
                                {{ setting()->getClientPhoneNumber() }}
                            </a>
                        @endif

                        @if(!empty(setting('client::company.email')))
                            <p class="mb-0 pb-0 mt-3">
                                Send us an Email
                            </p>
                            <a href="mailto:{{ setting('client::company.email') }}"
                               class="footer-email"
                               itemprop="email"
                               data-content="{{ setting('client::company.email') }}"
                            >
                                {{ setting('client::company.email') }}
                            </a>
                        @endif
                        @if(!empty(setting('client::office.line_1')))
                            <p class="mb-0 pb-0 mt-3">
                                Office Address
                            </p>
                            <p class="m-0"
                               itemscope
                               itemtype="http://schema.org/PostalAddress"
                               itemprop="address"
                            >
                                @if(!empty(setting('client::office.line_1')))
                                    <span itemprop="streetAddress" class="d-block">
                                        {{ setting('client::office.line_1') }},
                                    </span>
                                @endif

                                @if(!empty(setting('client::office.line_2')))
                                    <span class="d-block">
                                        {{ setting('client::office.line_2') }},
                                    </span>
                                @endif

                                @if(!empty(setting('client::office.city')))
                                    <span itemprop="addressLocality" class="d-block">
                                        {{ setting('client::office.city') }},
                                    </span>
                                @endif

                                @if(!empty(setting('client::office.postcode')))
                                    <span itemprop="postalCode" class="d-block">
                                        {{ setting('client::office.postcode') }}
                                    </span>
                                @endif
                            </p>
                        @endif

                        <div class="mt-4 footer-copyright">
                            <div class="mb-3">
                                @if(! empty(setting('client::registered.line_1')))
                                    <p class="d-flex flex-wrap mb-1 lh-base">
                                        @if(! empty(setting('client::company.name')))
                                            <span class="d-block pe-1">
                                                {{ setting('client::company.name') }},
                                            </span>
                                        @endif
                                        @if(! empty(setting('client::company.company_number')))
                                            <span class="d-block pe-1">
                                                Company No: {{ setting('client::company.company_number') }},
                                            </span>
                                            <span class="d-block pe-1">Registered in England &amp; Wales.</span>
                                        @endif
                                    </p>
                                    <p class="d-flex flex-wrap lh-base">
                                        Registered Address:&nbsp;
                                        @if(! empty(setting('client::registered.line_1')))
                                            <span class="d-block pe-1">
                                                {{ setting('client::registered.line_1') }},
                                            </span>
                                        @endif
                                        @if(! empty(setting('client::registered.line_2')))
                                            <span class="d-block pe-1">
                                                {{ setting('client::registered.line_2') }},
                                            </span>
                                        @endif
                                        @if(! empty(setting('client::registered.city')))
                                            <span class="d-block pe-1">
                                                {{ setting('client::registered.city') }},
                                            </span>
                                        @endif
                                        @if(! empty(setting('client::registered.postcode')))
                                            <span class="d-block pe-1">
                                                {{ setting('client::registered.postcode') }}.
                                            </span>
                                        @endif
                                    </p>
                                @endif
                            </div>

                            <div class="d-flex align-items-center">
                                <nav id="sub-menu">
                                    <ul>
                                        @includeIf('menu::frontend.partials.bottom_menu', ['key' => 'footer_menu'])
                                    </ul>
                                </nav>
                            </div>

                            <div class="d-flex align-items-center mt-3">
                                <p>
                                    &copy;{{ now()->format('Y') }}
                                    <span itemprop="name">{{ setting('client::company.name') }}</span>
                                    . All rights reserved.
                                    <a href="{{ setting('system::developer.credit_link') }}" {{ setting()->isNoFollow() ? 'rel=nofollow' : '' }}>
                                        {{ setting('system::developer.credit_text') }}
                                    </a>
                                </p>
                            </div>
                        </div>

                    </div>
                </div>

            </section>
        </div>

    </div>
</footer>

@section('footer_javascript')
    @parent
    @if(setting()->reCaptchaEnabled())
        {!! captcha()->script('enquiry') !!}
    @endif
@endsection
