<header
    id="header"
    class="header-6 @yield('header_class', setting()->getHeaderClass())"
    itemscope
    itemtype="http://schema.org/LocalBusiness"
>

    {{-- Header Middle--}}
    <div class="header-middle">
        <div class="container">
            <div class="row">

                {{-- Header Middle Left --}}
                <div class="col-6 col-lg-4 header-middle-left d-flex align-items-center">

                    {{-- Logo --}}
                    <a class="navbar-brand"
                       href="{{ url('/') }}"
                       itemprop="image" itemscope
                       itemtype="http://schema.org/ImageObject"
                    >
                        <img class="header-logo"
                             alt="{{ setting('client::company.name') }}"
                             src="{{ setting('theme::logo.default') }}"
                             itemprop="url"
                             data-content="{{ setting('theme::logo.default') }}"
                        >
                    </a>
                </div>

                {{-- Header Middle Right --}}
                <div
                    class="col-6 col-lg-8 header-middle-right d-flex flex-wrap align-items-center justify-content-end flex-lg-nowrap"
                >
                    @if(!empty(setting('client::company.email')))
                        <div class="header-text order-2 order-lg-1 d-none d-md-flex align-items-center">
                            <i class="fas fa-envelope fa-fw text-secondary opacity-30" style="font-size:3rem"></i>
                            <div class="header-text-wrap ms-n3">
                                <span class="d-block text-uppercase fw-bold text-primary opacity-80">
                                    Send Us An Email
                                </span>
                                <a class="d-block fs-4 fw-bold"
                                   href="mailto:{{ setting('client::company.email') }}"
                                   itemprop="email"
                                   data-content="{{ setting('client::company.email') }}"
                                >
                                    {{ setting('client::company.email') }}
                                </a>
                            </div>
                        </div>
                    @endif
                    @if(setting()->getClientPhoneNumber())
                        <div class="header-text order-1 order-lg-2 ms-lg-5 me-md-3 me-lg-0 d-flex align-items-center">
                            <i class="fas fa-phone fa-fw text-secondary opacity-30" style="font-size:3rem"></i>
                            <div class="header-text-wrap ms-n3">
                                <span class="d-block text-uppercase fw-bold text-primary opacity-80">
                                    Call Us Now
                                </span>
                                <a class="d-block fs-4 fw-bold"
                                   href="tel:{{ str_replace(' ', '', setting()->getClientPhoneNumber()) }}"
                                   itemprop="telephone"
                                   data-content="{{ setting()->getClientPhoneNumber() }}"
                                >
                                    {{ setting()->getClientPhoneNumber() }}
                                </a>
                            </div>
                        </div>
                    @endif
                </div>

            </div>
        </div>
    </div>

    {{-- Header Bottom--}}
    <div class="header-bottom">
        <nav class="navbar navbar-expand-lg">
            <div class="container">

                {{-- Burger Menu --}}
                <button class="navbar-toggler border-0"
                        type="button"
                        data-bs-toggle="collapse"
                        data-bs-target="#navbarNavDropdown"
                        aria-controls="navbarNavDropdown"
                        aria-expanded="false"
                        aria-label="Toggle navigation"
                >
                    <i class="fas fa-bars"></i>
                </button>

                {{-- Main Menu --}}
                <div class="collapse navbar-collapse justify-content-center" id="navbarNavDropdown">
                    <ul class="navbar-nav">
                        @includeIf('menu::frontend.partials.main_menu', ['key' => 'main_menu'])
                    </ul>
                </div>

            </div>
        </nav>
    </div>

</header>
