/**
 *  Promise for when the page is ready
 * @param fn
 */
function filePageReady(fn) {
    if (document.readyState === "complete" || document.readyState === "interactive") {
        setTimeout(fn, 1);
    } else {
        document.addEventListener("DOMContentLoaded", fn);
    }
}

/**
 * When the page is ready then run the following
 */
filePageReady(function() {
    if (document.querySelector('#files')) {
        var links = document.querySelectorAll('#files a');
        [].forEach.call(links, function (link) {
            var fileurl = link.getAttribute('href');
            link.addEventListener('click', (e) => {
                parent.selectFile(fileurl);
                e.preventDefault();
            });
        });
    }
});