<?php

namespace Bongo\Builder;

use Bongo\Builder\Facades\ComponentFacade;
use Bongo\Builder\Facades\DesignFacade;
use Bongo\Builder\Facades\LayoutFacade;
use Bongo\Builder\Http\Middleware\HasShortCodes;
use Bongo\Builder\Models\BuilderItem;
use Bongo\Framework\Providers\AbstractServiceProvider;
use Illuminate\Foundation\AliasLoader;

class BuilderServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'builder';

    protected array $middlewares = [
        'hasShortCodes' => HasShortCodes::class,
    ];

    public function register(): void
    {
        parent::register();

        $this->registerBindings();
    }

    public function boot(): void
    {
        parent::boot();

        $this->bootAssets();
    }

    protected function registerBindings(): void
    {
        // Create the bindings
        $this->app->singleton('component', fn () => new BuilderItem('component'));
        $this->app->singleton('design', fn () => new BuilderItem('design'));
        $this->app->singleton('layout', fn () => new BuilderItem('layout'));

        // Register the aliases
        AliasLoader::getInstance()->alias('Component', ComponentFacade::class);
        AliasLoader::getInstance()->alias('Design', DesignFacade::class);
        AliasLoader::getInstance()->alias('Layout', LayoutFacade::class);
    }

    protected function bootAssets(): void
    {
        $this->publishes([__DIR__.'/../public/' => public_path()], 'builder:assets');
    }
}
