<?php

namespace Bongo\Builder\Http\Controllers\Api;

use Bongo\Framework\Http\Controllers\AbstractApiController;
use Bongo\Gallery\Models\Gallery;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class GalleryController extends AbstractApiController
{
    public function index(Request $request)
    {
        $id = $request->get('ref');

        $gallery = Cache::remember("gallery-{$id}", config('settings.cache_default'),
            function () use ($id) {
                return Gallery::query()
                    ->with('images')
                    ->where('uuid', $id)
                    ->first();
            });

        return view('builder::api.gallery_builder')
            ->with([
                'gallery' => $gallery,
                'columns' => $request->get('columns', 4),
                'padding' => $request->get('padding', 0),
                'preset' => $request->get('preset', 'medium'),
                'quality' => $request->get('quality', 80),
                'lazy' => $request->get('lazy', false),
                'lightbox' => $request->get('lightbox', false),
            ])
            ->render();
    }
}
