<?php

namespace Bongo\Builder\Http\Controllers\Api;

use Bongo\Framework\Http\Controllers\AbstractApiController;
use Bongo\Review\Models\Review;
use Illuminate\Http\Request;

class ReviewController extends AbstractApiController
{
    public function index(Request $request)
    {
        $limit = $request->get('limit', 5);
        $characters = $request->get('characters', 100);

        $showTitle = $request->get('title', true);
        if (is_string($showTitle)) {
            $showTitle = $showTitle === 'true';
        }

        $reviews = Review::active()
            ->limit($limit)
            ->latest()
            ->get();

        return view('builder::api.review', compact('reviews', 'showTitle', 'characters'))->render();
    }
}
