<?php

namespace Bongo\Builder\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;

class IconController extends AbstractController
{
    public function index(): array
    {
        // Get the latest font awesome icons from github
        $content = file_get_contents('https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/metadata/icons.json');
        $json = json_decode($content);

        $styles = [
            'solid' => [
                'name' => 'Solid',
                'class' => 'fas',
                'icons' => []
            ],
            'regular' => [
                'name' => 'Regular',
                'class' => 'far',
                'icons' => []
            ],
            'brands' => [
                'name' => 'Brands',
                'class' => 'fab',
                'icons' => []
            ],
        ];

        foreach ($json as $icon => $value) {
            foreach ($value->styles as $style) {
                if (array_key_exists($style, $styles)) {
                    //$styles[$style]['icons'][] = 'fa'.substr($style, 0, 1).' fa-'.$icon;
                    $styles[$style]['icons'][] = $icon;
                }
            }
        }

        return $styles;
    }
}
