<?php

namespace Bongo\Builder\Http\Controllers\Backend;

use Bongo\Builder\Facades\LayoutFacade;
use Bongo\Builder\Models\BuilderItem;
use Bongo\Framework\Http\Controllers\AbstractController;
use Exception;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\View\View;

class LayoutController extends AbstractController
{
    public function index(Request $request): View
    {
        if (config('settings.memory_limit') && ! empty(config('settings.memory_limit'))) {
            ini_set('memory_limit', config('settings.memory_limit'));
        }

        $categories = LayoutFacade::categories();

        $category = $request->get('category', 'footers');
        $layouts = LayoutFacade::findByCategory($category);

        return view('builder::backend.layout.index', compact('categories', 'layouts'));
    }

    public function create(): View
    {
        $layout = new BuilderItem('layout');

        return view('builder::backend.layout.create', compact('layout'));
    }

    public function show(string $key): View
    {
        $layout = LayoutFacade::findOrFail($key);

        return view('builder::backend.layout.show', compact('layout'));
    }

    /**
     * @throws Exception
     */
    public function store(Request $request): RedirectResponse
    {
        // Create a new layout instance
        $layout = new BuilderItem('layout');
        $thumbnail = $this->getFileContents($request) ?? $layout->getRawThumbnail();

        // Save the changes
        $layout->setName($request->get('name'));
        $layout->setKey($request->get('name'));
        $layout->setCategory($request->get('category'));
        $layout->setThumbnail($thumbnail);
        $layout->setHtml($request->get('html'));
        $layout->save();

        return redirect()
            ->route('backend.layout.show', $layout->key)
            ->success(trans('builder::backend.layout_store_success'));
    }

    public function edit(string $key): View
    {
        $layout = LayoutFacade::findOrFail($key);

        return view('builder::backend.layout.edit', compact('layout'));
    }

    public function update(Request $request, string $key): RedirectResponse
    {
        // Find the existing layout
        $layout = LayoutFacade::find($key);
        $thumbnail = $this->getFileContents($request) ?? $layout->getRawThumbnail();

        // Delete the old one
        $layout->delete();

        // Save the changes
        $layout->setName($request->get('name'));
        $layout->setKey($request->get('name'));
        $layout->setCategory($request->get('category'));
        $layout->setThumbnail($thumbnail);
        $layout->setHtml($request->get('html'));
        $layout->save();

        return redirect()
            ->route('backend.layout.show', $layout->key)
            ->success(trans('builder::backend.layout_update_success'));
    }

    public function destroy(string $key): RedirectResponse
    {
        $layout = LayoutFacade::find($key);
        $layout->delete();

        return redirect()
            ->route('backend.layout.index')
            ->success(trans('builder::backend.layout_delete_success'));
    }

    private function getFileContents(Request $request): ?string
    {
        if ($file = $request->file('thumbnail')) {
            return File::get($file->getRealPath());
        }

        return null;
    }
}
