<?php

use Bongo\Builder\Http\Controllers\Api\ButtonController;
use Bongo\Builder\Http\Controllers\Api\ComponentController;
use Bongo\Builder\Http\Controllers\Api\DesignController;
use Bongo\Builder\Http\Controllers\Api\FileController;
use Bongo\Builder\Http\Controllers\Api\FontController;
use Bongo\Builder\Http\Controllers\Api\IconController;
use Bongo\Builder\Http\Controllers\Api\ImageController;
use Bongo\Builder\Http\Controllers\Api\ModuleController;
use Bongo\Builder\Http\Controllers\Api\SnippetController;
use Bongo\Builder\Http\Controllers\Api\StyleController;
use Bongo\Builder\Http\Controllers\Api\SymbolController;
use Illuminate\Support\Facades\Route;

Route::prefix('builder')
    ->as('builder.')
    ->group(function () {

        Route::get('/', [ComponentController::class, 'index'])
            ->name('index');

        Route::get('buttons', [ButtonController::class, 'index'])
            ->name('button.index');

        Route::get('designs', [DesignController::class, 'index'])
            ->name('design.index');

        Route::get('snippets', [SnippetController::class, 'index'])
            ->name('snippet.index');

        Route::get('files', [FileController::class, 'index'])
            ->name('file.index');

        Route::get('fonts', [FontController::class, 'index'])
            ->name('font.index');

        Route::get('images', [ImageController::class, 'index'])
            ->name('image.index');

        Route::get('icons', [IconController::class, 'index'])
            ->name('icon.index');

        Route::get('symbols', [SymbolController::class, 'index'])
            ->name('symbol.index');

        Route::get('styles', [StyleController::class, 'index'])
            ->name('style.index');

        Route::get('modules/{module}', [ModuleController::class, 'index'])
            ->name('module.index');
    });
