<!DOCTYPE HTML>
<html>
    <head>
        <meta charset="utf-8">
        <title></title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <link rel="stylesheet" href="{{ config('builder.vendor_asset_path') }}/bootstrap.css">
        <link rel="stylesheet" href="{{ config('builder.backend_asset_path') }}/modules/css/settings.css">
    </head>
    <body>
        <div id="settings-wrapper">
            <div class="container">
                <div class="form-row w-100">
                    <div class="form-group col-12">
                        <label for="ref">Select Category:</label>
                        <select id="ref" class="form-control">
                            <option value="">-- All Categories --</option>
                            @foreach(ProjectCategory::all() as $projectCategory)
                                <option value="{{ $projectCategory->uuid }}">{{ $projectCategory->name }}
                                    - {{ $projectCategory->id }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-6">
                        <label for="style">Style:</label>
                        <select id="style" class="form-control">
                            <option value="style-1">Style 1</option>
                            <option value="style-2">Style 2</option>
                            <option value="style-3">Style 3</option>
                            <option value="style-4">Style 4</option>
                            <option value="style-5">Style 5</option>
                        </select>
                    </div>

                    <div class="form-group col-6">
                        <label for="columns">Columns:</label>
                        <select id="columns" class="form-control">
                            <option value="1">1 Columns</option>
                            <option value="2">2 Columns</option>
                            <option value="3">3 Columns</option>
                            <option value="4">4 Columns</option>
                            <option value="5">5 Columns</option>
                            <option value="6">6 Columns</option>
                        </select>
                    </div>
                    <div class="form-group col-6">
                        <label for="padding">Padding:</label>
                        <select id="padding" class="form-control">
                            <option value="0">None</option>
                            <option value="3">Small</option>
                            <option value="6">Medium</option>
                            <option value="12">Large</option>
                        </select>
                    </div>

                    <div class="form-group col-6">
                        <label for="number-projects">Number of Projects:</label>
                        <input id="number-projects" type="text" class="form-control" value="3"/>
                    </div>
                    <div class="form-group col-6">
                        <label for="number-characters">Number of Characters:</label>
                        <input id="number-characters" type="text" class="form-control" value="100"/>
                    </div>
                </div>

                <div class="form-row w-100">
                    <div class="form-group col-6">
                        <label>
                            <input id="lazy" class="input-lazy" type="checkbox"/>
                            Lazy Load
                        </label>
                    </div>
                    <div class="form-group col-6">
                        <label>
                            <input id="show-summary" class="input-show-summary" type="checkbox"/>
                            Summary
                        </label>
                    </div>
                    <div class="form-group col-6">
                        <label>
                            <input id="show-button" class="input-show-button" type="checkbox"/>
                            Show Button
                        </label>
                    </div>
                    <div class="form-group col-6">
                        <label>
                            <input id="randomise" class="input-randomise" type="checkbox"/>
                            Randomise
                        </label>
                    </div>
                </div>
            </div>
        </div>

        <script src="{{ config('builder.backend_asset_path') }}/modules/js/project.js"></script>
    </body>
</html>
