<!DOCTYPE HTML>
<html>
    <head>
        <meta charset="utf-8">
        <title></title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <link rel="stylesheet" href="{{ config('builder.vendor_asset_path') }}/bootstrap.css">
        <link rel="stylesheet" href="{{ config('builder.backend_asset_path') }}/modules/css/settings.css">
    </head>
    <body>
        <svg width="0" height="0" style="position:absolute; display:none;">
            <defs>
                <symbol viewBox="0 0 512 512" id="ion-ios-arrow-thin-up">
                    <path
                        d="M349.7 189.8c-3.1 3.1-8 3-11.3 0L264 123.4V408c0 4.4-3.6 8-8 8s-8-3.6-8-8V123.4l-74.4 66.3c-3.4 2.9-8.1 3.2-11.2.1-3.1-3.1-3.3-8.5-.1-11.4 0 0 87-79.2 88-80s2.8-2.4 5.7-2.4 4.9 1.6 5.7 2.4 88 80 88 80c1.5 1.5 2.3 3.6 2.3 5.7s-.8 4.1-2.3 5.7z"
                    ></path>
                </symbol>
                <symbol viewBox="0 0 512 512" id="ion-ios-arrow-thin-down">
                    <path
                        d="M349.7 322.2c-3.1-3.1-8-3-11.3 0L264 388.6V104c0-4.4-3.6-8-8-8s-8 3.6-8 8v284.6l-74.4-66.3c-3.4-2.9-8.1-3.2-11.2-.1-3.1 3.1-3.3 8.5-.1 11.4 0 0 87 79.2 88 80s2.8 2.4 5.7 2.4 4.9-1.6 5.7-2.4 88-80 88-80c1.5-1.5 2.3-3.6 2.3-5.7s-.8-4.1-2.3-5.7z"
                    ></path>
                </symbol>
                <symbol viewBox="0 0 512 512" id="ion-ios-close-empty">
                    <path
                        d="M340.2 160l-84.4 84.3-84-83.9-11.8 11.8 84 83.8-84 83.9 11.8 11.7 84-83.8 84.4 84.2 11.8-11.7-84.4-84.3 84.4-84.2z"
                    ></path>
                </symbol>
            </defs>
        </svg>

        <div id="settings-wrapper">

            <div id="settings-left">
                <div id="slides"></div>
                <button class="input-add btn btn-block btn-secondary">
                    + Add Item
                </button>
            </div>

            <div id="settings-right" style="overflow-y: auto">

                <div class="w-100">
                    <div class="form-row w-100">

                        <div class="form-group col-md-4">
                            <label for="type">Type:</label>
                            <select id="type" class="form-control">
                                <option value="slider">Slider</option>
                                <option value="carousel">Carousel</option>
                            </select>
                        </div>

                        <div class="form-group col-md-4">
                            <label for="style">Style:</label>
                            <select id="style" class="form-control">
                                <option value="style-1">Style 1</option>
                                <option value="style-2">Style 2</option>
                                <option value="style-3">Style 3</option>
                                <option value="style-4">Style 4</option>
                                <option value="style-5">Style 5</option>
                            </select>
                        </div>

                        <div id="slider-block" class="form-group col-md-4" style="display: none">
                            <label for="transition">Transition:</label>
                            <select id="transition" class="form-control">
                                <option value="slide">Slide</option>
                                <option value="fade">Fade</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div id="carousel-block" class="w-100" style="display: none">
                    <div class="settings-divider"></div>

                    <div class="form-row w-100">
                        <div class="form-group col-md-3">
                            <label for="items">Per View:</label>
                            <select id="items" class="form-control">
                                <option value="1">1</option>
                                <option value="2">2</option>
                                <option value="3">3</option>
                                <option value="4">4</option>
                                <option value="5">5</option>
                                <option value="6">6</option>
                                <option value="7">7</option>
                                <option value="8">8</option>
                            </select>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="margin">Margin:</label>
                            <input id="margin" type="text" class="form-control" value="0"
                                   onkeypress="return isNumber(event)"
                            />
                        </div>
                    </div>
                </div>

                <div id="checkboxes" class="w-100">
                    <div class="settings-divider"></div>
                    <div class="form-row w-100">
                        <div class="form-group col-md-12">
                            <div class="form-check form-check-inline">
                                <input id="loop" class="form-check-input" type="checkbox" checked="checked">
                                <label for="loop" class="form-check-label">Loop</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input id="lazy" class="form-check-input" type="checkbox" checked="checked">
                                <label for="lazy" class="form-check-label">Lazy Load</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input id="nav" class="form-check-input" type="checkbox" checked="checked">
                                <label for="nav" class="form-check-label">Arrows</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input id="dots" class="form-check-input" type="checkbox" checked="checked">
                                <label for="dots" class="form-check-label">Dots</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input id="autoplay" class="form-check-input" type="checkbox" checked="checked">
                                <label for="autoplay" class="form-check-label">Autoplay</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input id="pause" class="form-check-input" type="checkbox" checked="checked">
                                <label for="pause" class="form-check-label">Pause On Hover</label>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="caption-block" class="w-100">

                    <div class="settings-divider"></div>

                    <div class="form-row w-100">
                        <div class="form-group col-md-6">
                            <label id="title-label" for="title">Item Title:</label>
                            <input id="title" type="text" class="form-control"/>
                        </div>
                        <div class="form-group col-md-6">
                            <label id="action-label" for="action">Item Action: (e.g /contact-us)</label>
                            <input id="action" type="text" class="form-control">
                        </div>
                        <div class="form-group col-md-12">
                            <label id="description-label" for="description">Item Description: (HTML allowed)</label>
                            <textarea id="description" class="form-control"></textarea>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <script src="{{ config('builder.backend_asset_path') }}/modules/js/slider.js"></script>
    </body>
</html>
