@honeypot

@php
    $captchaEnabled = setting()->reCaptchaEnabled();
    $captchaSiteKey = setting()->getReCaptchaSiteKey();
    $captchaField = uniqid('captcha-response-');
@endphp

@if($captchaEnabled)
    <div
        class="captcha-container"
        data-captcha="{{ $captchaEnabled }}"
        data-captcha-key="{{ $captchaSiteKey }}"
        data-captcha-field="{{ $captchaField }}"
        data-captcha-action="{{ $name }}"
    >
        <input id="{{ $captchaField }}"
               class="g-recaptcha"
               type="hidden"
               name="captcha-response"
               data-key="{{ $captchaSiteKey }}"
               data-action="{{ $name }}"
        >
    </div>
@endif
