<?php

$id = Str::random(5);

$moduleHtml = '
    <div id="'.$id.'" class="post-builder"></div>

    <script>
        var '.$id.'_docReady = function (fn) {
            var stateCheck = setInterval(function () {
                if (document.readyState !== "complete") return;
                clearInterval(stateCheck);
                try {fn()} catch (e) {}
            }, 1000);
        };
        '.$id.'_docReady(function () {
            var xmlhttp = new XMLHttpRequest();
            xmlhttp.onreadystatechange = function() {
                if (xmlhttp.readyState === XMLHttpRequest.DONE) {
                    if (xmlhttp.status === 200) {
                        let postContainer = document.getElementById("'.$id.'");
                        postContainer.innerHTML = xmlhttp.responseText;

                        if (document.body.classList.contains("web-editor")) {
                            var anchors = document.getElementsByClassName("card-link");
                            if (anchors.length > 0) {
                                for (var i = 0; i < anchors.length; i++) {
                                    anchors[i].style = "pointer-events: none; cursor: default;";
                                }
                            }
                        }
                    }
                }
            };
            xmlhttp.open("GET", "/api/builder/post", true);
            xmlhttp.send();
        });
    </script>
';

$moduleSettings = '
    {
        "ref": "",
        "style": "style-1",
        "columns": "3",
        "padding": "3",
        "lazy_load": false,
        "show_summary": false,
        "show_button": false,
        "randomise": false,
        "number_characters": 100,
        "number_posts": 3
    }
';
?>

<div class="row clearfix border-0">
    <div class="col-12"
         data-noedit
         data-module="post"
         data-dialog-width="500px"
         data-module-desc="Post"
         data-html="{{ encode_uri_component($moduleHtml) }}"
         data-settings="{{ encode_uri_component($moduleSettings) }}"
    >
    </div>
</div>
