<footer id="footer" class="footer-2" itemscope itemtype="http://schema.org/LocalBusiness">

    <div class="d-none" itemprop="image" itemscope itemtype="http://schema.org/ImageObject">
        <span itemprop="url" data-content="{{ setting('theme::logo.light') }}"></span>
    </div>

    <div class="container">
        <div class="row py-5">

            <div class="col-md-5 col-lg-4 mb-5 mb-lg-0"
                 itemscope
                 itemtype="http://schema.org/PostalAddress"
                 itemprop="address"
            >
                <h5 class="mb-4">Contact Details</h5>

                <p class="mb-3">
                    @if(!empty(setting('client::office.line_1')))
                        <span itemprop="streetAddress">
                            {{ setting('client::office.line_1') }}, {{ setting('client::office.line_2') }}
                        </span>
                    @endif
                    @if(!empty(setting('client::office.city')))
                        <span itemprop="addressLocality">
                            {{ setting('client::office.city') }},
                        </span>
                        <span itemprop="postalCode">
                            {{ setting('client::office.postcode') }}
                        </span>
                    @endif
                </p>

                @if(setting()->getClientPhoneNumber())
                    <p class="mb-0">
                        Phone:
                        <a href="tel:{{ str_replace(' ', '', setting()->getClientPhoneNumber()) }}"
                           class="text-color-primary"
                           itemprop="telephone"
                           data-content="{{ setting()->getClientPhoneNumber() }}"
                        >
                            {{ setting()->getClientPhoneNumber() }}
                        </a>
                    </p>
                @endif

                @if(!empty(setting('client::company.email')))
                    <p class="mb-0">
                        Email:
                        <a href="mailto:{{ setting('client::company.email') }}"
                           class="text-color-primary"
                           itemprop="email"
                           data-content="{{ setting('client::company.email') }}"
                        >
                            {{ setting('client::company.email') }}
                        </a>
                    </p>
                @endif
            </div>

            <div class="col-md-7 col-lg-6 mb-5 mb-lg-0">
                <h5 class="mb-4">Links</h5>
                @includeIf('menu::frontend.partials.footer_menu', ['key' => 'footer_menu', 'showBullets' => true, 'ulClass' => 'm-0'])
            </div>

            <div class="col-lg-2">
                <h5 class="mb-4">Follow Us</h5>

                <ul class="social-icons social-icons-clean social-icons-opacity-light social-icons-icon-light mt-1">

                    @if(!empty(setting('client::social.facebook')))
                        <li class="social-icons-facebook">
                            <a class="social-icon" href="{{ setting('client::social.facebook') }}" target="_blank"
                               title="Facebook"
                            >
                                <i class="fab fa-facebook-f"></i>
                            </a>
                        </li>
                    @endif

                    @if(!empty(setting('client::social.twitter')))
                        <li class="social-icons-twitter">
                            <a class="social-icon" href="{{ setting('client::social.twitter') }}" target="_blank"
                               title="Twitter"
                            >
                                <i class="fab fa-twitter"></i>
                            </a>
                        </li>
                    @endif

                    @if(!empty(setting('client::social.instagram')))
                        <li class="social-icons-instagram">
                            <a class="social-icon" href="{{ setting('client::social.instagram') }}" target="_blank"
                               title="Instagram"
                            >
                                <i class="fab fa-instagram"></i>
                            </a>
                        </li>
                    @endif

                    @if(!empty(setting('client::social.youtube')))
                        <li class="social-icons-youtube">
                            <a class="social-icon" href="{{ setting('client::social.youtube') }}" target="_blank"
                               title="Youtube"
                            >
                                <i class="fab fa-youtube"></i>
                            </a>
                        </li>
                    @endif

                    @if(!empty(setting('client::social.linkedin')))
                        <li class="social-icons-linkedin">
                            <a class="social-icon" href="{{ setting('client::social.linkedin') }}" target="_blank"
                               title="Linkedin"
                            >
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        </li>
                    @endif

                    @if(!empty(setting('client::social.pinterest')))
                        <li class="social-icons-pinterest">
                            <a class="social-icon" href="{{ setting('client::social.pinterest') }}" target="_blank"
                               title="Pinterest"
                            >
                                <i class="fab fa-pinterest"></i>
                            </a>
                        </li>
                    @endif

                </ul>

            </div>
        </div>
    </div>

    <div class="footer-copyright">
        <div class="container">
            <div class="row py-3">
                <div class="col-12">
                    @if(! empty(setting('client::registered.line_1')))
                        <p class="m-2 d-flex justify-content-center flex-wrap">
                            @if(! empty(setting('client::registered.line_1')))
                                <span itemprop="streetAddress" class="d-block pe-2">
                                    {{ setting('client::registered.line_1') }},
                                </span>
                            @endif
                            @if(! empty(setting('client::registered.line_2')))
                                <span class="d-block pe-2">
                                    {{ setting('client::registered.line_2') }},
                                </span>
                            @endif
                            @if(! empty(setting('client::registered.city')))
                                <span itemprop="addressLocality" class="d-block pe-2">
                                    {{ setting('client::registered.city') }},
                                </span>
                            @endif
                            @if(! empty(setting('client::registered.postcode')))
                                <span itemprop="postalCode" class="d-block pe-2">
                                    {{ setting('client::registered.postcode') }}
                                </span>
                            @endif
                            @if(! empty(setting('client::company.name')))
                                <span class="d-block pe-2">
                                    {{ setting('client::company.name') }}
                                </span>
                            @endif
                            @if(! empty(setting('client::company.company_number')))
                                <span class="d-block pe-2">
                                    Company No:  {{ setting('client::company.company_number') }}
                                </span>
                            @endif
                            <span>Registered in England &amp; Wales</span>
                        </p>
                    @endif
                </div>

                <div class="col-lg-12 d-flex align-items-center justify-content-center mb-4 mb-lg-0">
                    <p>
                        &copy;{{ now()->format('Y') }}
                        <span itemprop="name">{{ setting('client::company.name') }}</span>
                        . All rights reserved.
                        <a href="{{ setting('system::developer.credit_link') }}" {{ setting()->isNoFollow() ? 'rel=nofollow' : '' }}>
                            {{ setting('system::developer.credit_text') }}
                        </a>
                    </p>
                </div>

            </div>
        </div>
    </div>
</footer>