<header
    id="header"
    class="header-7 @yield('header_class', setting()->getHeaderClass())"
    itemscope
    itemtype="http://schema.org/LocalBusiness"
>

    {{-- Header Middle--}}
    <div class="header-middle">
        <div class="container">
            <div class="row flex-md-row-reverse">
                {{-- Header Middle Left --}}
                <div class="col-12 col-lg-4 header-middle-left d-flex justify-content-end position-relative">

                    {{-- Logo --}}
                    <a class="header-top-logo d-block align-self-center z-1"
                       href="{{ url('/') }}"
                       itemprop="image" itemscope
                       itemtype="http://schema.org/ImageObject"
                    >
                        <img class="header-logo"
                             alt="{{ setting('client::company.name') }}"
                             src="{{ setting('theme::logo.default') }}"
                             itemprop="url"
                             data-content="{{ setting('theme::logo.default') }}"
                        >
                    </a>

                    {{-- Burger Menu --}}
                    <button class="navbar-toggler ml-auto align-self-center d-lg-none"
                            type="button"
                            data-bs-toggle="collapse"
                            data-bs-target="#navbarNavDropdown"
                            aria-controls="navbarNavDropdown"
                            aria-expanded="false"
                            aria-label="Toggle navigation"
                    >
                        <i class="fas fa-bars"></i>
                    </button>
                </div>
                {{-- Header Middle Right --}}
                <div
                    class="col-12 col-lg-8 header-middle-right d-lg-flex flex-wrap align-items-lg-center bg-secondary py-lg-3"
                >
                    {{-- Top row --}}
                    <div class="header-middle-top d-none d-lg-flex align-self-center w-100 ps-3">
                        <nav class="sub-navbar">
                            <ul>
                                @includeIf('menu::frontend.partials.top_menu', ['key' => 'top_menu'])
                                @if(setting('client::company.email'))
                                    <li class="nav-item nav-item-email">
                                        <a href="mailto:{{ setting('client::company.email') }}"
                                           itemprop="email"
                                           data-content="{{ setting('client::company.email') }}"
                                        >
                                            <i class="fas fa-envelope me-1"></i>
                                            {{ setting('client::company.email') }}
                                        </a>
                                    </li>
                                @endif
                                @if(setting()->getClientPhoneNumber())
                                    <li class="nav-item nav-item-phone">
                                        <a href="tel:{{ str_replace(' ', '', setting()->getClientPhoneNumber()) }}"
                                           itemprop="telephone"
                                           data-content="{{ setting()->getClientPhoneNumber() }}"
                                        >
                                            <i class="fas fa-phone me-1"></i>
                                            {{ setting()->getClientPhoneNumber() }}
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </nav>
                    </div>

                    {{-- Bottom row --}}
                    <div class="header-middle-bottom w-100">
                        <nav class="navbar navbar-expand-lg header-middle-bottom-nav d-flex">

                            {{-- Main Menu --}}
                            <div class="collapse navbar-collapse align-self-center"
                                 id="navbarNavDropdown"
                            >
                                <ul class="navbar-nav">
                                    @includeIf('menu::frontend.partials.main_menu', ['key' => 'main_menu'])
                                </ul>
                            </div>

                            {{-- Social icons --}}
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>

</header>
