<header
    id="header"
    class="header-9 @yield('header_class', setting()->getHeaderClass())"
    itemscope
    itemtype="http://schema.org/LocalBusiness"
>
    {{-- Header Middle--}}
    <div class="header-middle">
        <nav class="navbar navbar-expand-lg">
            <div class="container-fluid container-lg flex-wrap">

                {{-- phone icon --}}
                <span class="d-block d-lg-none snake-button-rounded phone-icon bg-dark-30 rounded-pill">
                    <a href="tel:[company_phone]"
                       class="btn btn-lg btn-primary rounded-pill px-4 py-1 px-md-4 py-md-2"
                       title=""
                    >
                        <i class="fa-solid fa-phone"></i>
                    </a>
                </span>

                {{-- Logo --}}
                <a id="header-logo"
                   class="navbar-brand"
                   href="{{ url('/') }}"
                   itemprop="image" itemscope
                   itemtype="http://schema.org/ImageObject"
                >
                    <img class="header-logo"
                         alt="{{ setting('client::company.name') }}"
                         src="{{ setting('theme::logo.default') }}"
                         itemprop="url"
                         data-content="{{ setting('theme::logo.default') }}"
                    >
                </a>

                {{-- Burger Menu --}}
                <button
                    class="navbar-toggler border-0 px-3"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#navbarNavDropdown"
                    aria-controls="navbarNavDropdown"
                    aria-expanded="false"
                    aria-label="Toggle navigation"
                >
                    <i class="fas fa-bars"></i>
                </button>

                {{-- Main Menu --}}
                <div class="collapse navbar-collapse justify-content-center" id="navbarNavDropdown">
                    <ul class="navbar-nav">
                        @includeIf('menu::frontend.partials.main_menu', ['key' => 'main_menu'])
                    </ul>
                </div>

                <span class="d-none d-lg-block snake-button-rounded bg-dark-30 rounded-pill">
                    <a href="tel:[company_phone] phone_icon"
                       class="btn btn-lg btn-primary rounded-pill"
                       title=""
                    >
                        Contact
                    </a>
                </span>

            </div>
        </nav>
    </div>
</header>
