<?php

namespace Bongo\Builder;

use Bongo\Builder\Facades\ComponentFacade;
use Bongo\Builder\Models\BuilderItem;
use Bongo\Builder\Facades\DesignFacade;
use Bongo\Framework\Providers\AbstractServiceProvider;
use Bongo\Builder\Http\Middleware\HasShortCodes;
use Illuminate\Foundation\AliasLoader;
use ReflectionException;

class BuilderServiceProvider extends AbstractServiceProvider
{
    /** @var string */
    protected $module = 'builder';

    /** @var array */
    protected $middlewares = [
        'hasShortCodes' => HasShortCodes::class,
    ];

    /**
     * @throws ReflectionException
     */
    public function boot()
    {
        parent::boot();

        // Create the component facade
        $this->app->singleton('component', function () {
            return new BuilderItem('component');
        });
        AliasLoader::getInstance()->alias('Component', ComponentFacade::class);

        // Create the design facade
        $this->app->singleton('design', function () {
            return new BuilderItem('design');
        });
        AliasLoader::getInstance()->alias('Design', DesignFacade::class);
    }
}
