<?php

namespace Bongo\Builder\Http\Controllers\Api;

use Bongo\Framework\Http\Controllers\AbstractApiController;
use Illuminate\Http\Request;

class ModuleController extends AbstractApiController
{
    public function index(Request $request, string $module)
    {
        $module = str_replace('.html', '', $module);

        if (view()->exists("builder::api.modules.{$module}")) {
            return view("builder::api.modules.{$module}")->render();
        }

        return "<h2>Module: {$module} not found</h2>";
    }
}
